/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Parapet
extends Block {
    public static final EnumProperty<Flower> FLOWER = EnumProperty.create((String)"part", Flower.class);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    protected static final VoxelShape SOUTH = Shapes.or((VoxelShape)Parapet.box((double)9.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape EAST = Shapes.or((VoxelShape)Parapet.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape WEST = Shapes.or((VoxelShape)Parapet.box((double)0.0, (double)12.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH = Shapes.or((VoxelShape)Parapet.box((double)0.0, (double)12.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);

    public Parapet(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(FLOWER, (Comparable)((Object)Flower.EMPTY)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.getValue(FACING)) {
            case WEST: {
                return WEST;
            }
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
        }
        return NORTH;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FLOWER, (Comparable)((Object)Flower.byState(context.getLevel().getBlockState(context.getClickedPos().above()))))).setValue(FACING, (Comparable)context.getHorizontalDirection().getClockWise());
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return facing == Direction.UP ? (BlockState)state.setValue(FLOWER, (Comparable)((Object)Flower.byState(facingState))) : super.updateShape(state, level, ticker, currentPos, facing, facingPos, facingState, random);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FLOWER});
    }

    public static enum Flower implements StringRepresentable
    {
        FLOWER("flower"),
        EMPTY("empty");

        private final String name;

        private Flower(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Flower byState(BlockState state) {
            if (state.is(BlockTags.FLOWER_POTS)) {
                return FLOWER;
            }
            return EMPTY;
        }
    }
}

