/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.item;

import fuzs.illagerinvasion.init.ModSoundEvents;
import fuzs.illagerinvasion.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class LostCandleItem
extends Item {
    public LostCandleItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (level.isClientSide()) {
            for (BlockPos blockPos : BlockPos.withinManhattan((BlockPos)player.blockPosition(), (int)8, (int)8, (int)8)) {
                BlockState blockState = level.getBlockState(blockPos);
                if (!blockState.is(ModTags.ORES_BLOCK_TAG)) continue;
                level.playSound((Entity)player, player.blockPosition(), (SoundEvent)ModSoundEvents.LOST_CANDLE_FIND_ORE_SOUND_EVENT.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                MutableComponent component = blockState.getBlock().getName().withColor(blockState.getMapColor((BlockGetter)level, (BlockPos)blockPos).col);
                player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".foundNearby"), (Object[])new Object[]{component}), true);
                return InteractionResult.SUCCESS;
            }
            level.playSound((Entity)player, player.blockPosition(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.6f, 1.0f);
        } else {
            player.getCooldowns().addCooldown(context.getItemInHand(), 60);
        }
        return InteractionResult.SUCCESS;
    }
}

