/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.projectile;

import fuzs.illagerinvasion.init.ModEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SkullBolt
extends WitherSkull {
    public SkullBolt(EntityType<? extends SkullBolt> entityType, Level level) {
        super(entityType, level);
    }

    public SkullBolt(Level level, LivingEntity owner, Vec3 movement) {
        this((EntityType<? extends SkullBolt>)((EntityType)ModEntityTypes.SKULL_BOLT_ENTITY_TYPE.value()), level);
        this.setOwner((Entity)owner);
        this.setRot(owner.getYRot(), owner.getXRot());
        this.snapTo(owner.getX(), owner.getY(), owner.getZ(), this.getYRot(), this.getXRot());
        this.reapplyPosition();
        this.assignDirectionalMovement(movement, this.accelerationPower);
    }

    public float getBlockExplosionResistance(Explosion explosion, BlockGetter level, BlockPos pos, BlockState blockState, FluidState fluidState, float explosionPower) {
        return 3600000.0f;
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                entity = entityHitResult.getEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)entity;
                    if (target.getType().is(EntityTypeTags.UNDEAD)) {
                        target.heal(5.0f);
                        target.addEffect(new MobEffectInstance(MobEffects.SPEED, 100, 2));
                    } else {
                        DamageSource damageSource = this.damageSources().indirectMagic((Entity)this, (Entity)owner);
                        target.hurtServer(serverLevel, damageSource, 7.0f);
                        EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)target, (DamageSource)damageSource);
                        target.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 100, 1));
                    }
                }
            }
        }
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = this.getX();
            double y = this.getY() + 0.2;
            double z = this.getZ();
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 25, 0.25, 0.25, 0.25, 0.05);
            this.discard();
        }
    }

    public boolean isDangerous() {
        return false;
    }
}

