/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.illagerinvasion.init.ModSoundEvents;
import fuzs.illagerinvasion.world.entity.projectile.SkullBolt;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class Necromancer
extends SpellcasterIllager {
    private static final EntityDataAccessor<Boolean> DATA_IS_SHIELDED = SynchedEntityData.defineId(Necromancer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int conjureSkullCooldown;

    public Necromancer(EntityType<? extends Necromancer> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 10;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creaking.class, 8.0f, 1.0, 1.2));
        this.goalSelector.addGoal(2, (Goal)new SpellcasterIllager.SpellcasterCastingSpellGoal((SpellcasterIllager)this));
        this.goalSelector.addGoal(4, (Goal)new ConjureSkullGoal());
        this.goalSelector.addGoal(3, (Goal)new SummonUndeadGoal());
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_SHIELDED, (Object)false);
    }

    public boolean getShieldedState() {
        return (Boolean)this.entityData.get(DATA_IS_SHIELDED);
    }

    public void setShieldedState(boolean isShielded) {
        this.entityData.set(DATA_IS_SHIELDED, (Object)isShielded);
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.ILLUSIONER_AMBIENT;
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        super.customServerAiStep(serverLevel);
        --this.conjureSkullCooldown;
        List mobs = serverLevel.getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate(10.0), mob -> mob.getType().is(EntityTypeTags.UNDEAD));
        if (!mobs.isEmpty()) {
            mobs.forEach(this::doUndeadLinkLogic);
            if (this.tickCount % 10 == 0) {
                mobs.forEach(this::doUndeadLinkParticle);
            }
        }
        if (this.tickCount % 20 == 0) {
            this.setShieldedState(!mobs.isEmpty());
        }
        if (this.getTarget() != null) {
            mobs = serverLevel.getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate(30.0), mob -> mob.getType().is(EntityTypeTags.UNDEAD));
            mobs.forEach(this::setUndeadTarget);
        }
    }

    public boolean canAttack(LivingEntity target) {
        return !target.getType().is(EntityTypeTags.UNDEAD) && super.canAttack(target);
    }

    public void doUndeadLinkLogic(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.STRENGTH, 10, 0));
        entity.addEffect(new MobEffectInstance(MobEffects.SPEED, 10, 0));
        entity.clearFire();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setTarget(this.getTarget());
        }
    }

    public void setUndeadTarget(LivingEntity entity) {
        if (this.getTarget() != null && entity instanceof Mob) {
            ((Mob)entity).setTarget(this.getTarget());
        }
    }

    public void doUndeadLinkParticle(LivingEntity entity) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = entity.getX();
            double y = entity.getY();
            double z = entity.getZ();
            serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)ModRegistry.NECROMANCER_BUFF_PARTICLE_TYPE.value()), x, y + 1.0, z, 1, 0.4, 0.5, 0.4, 0.015);
            serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)ModRegistry.NECROMANCER_BUFF_PARTICLE_TYPE.value()), this.getX(), this.getY() + 1.0, this.getZ(), 1, 0.4, 0.5, 0.4, 0.015);
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float damageAmount) {
        return super.hurtServer(serverLevel, damageSource, this.getShieldedState() ? damageAmount / 2.0f : damageAmount);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ILLUSIONER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ILLUSIONER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.ILLUSIONER_HURT;
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public boolean isPowered() {
        return this.getShieldedState();
    }

    public class ConjureSkullGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public ConjureSkullGoal() {
            super((SpellcasterIllager)Necromancer.this);
        }

        public boolean canUse() {
            if (Necromancer.this.getTarget() == null) {
                return false;
            }
            if (Necromancer.this.conjureSkullCooldown > 0) {
                return false;
            }
            if (Necromancer.this.conjureSkullCooldown <= 0) {
                return true;
            }
            return true;
        }

        private void shootSkullAt(double targetX, double targetY, double targetZ) {
            double d = Necromancer.this.getX();
            double e = Necromancer.this.getY() + 2.5;
            double f = Necromancer.this.getZ();
            double g = targetX - d;
            double h = targetY - e;
            double i = targetZ - f;
            Vec3 vec3 = new Vec3(g, h, i);
            SkullBolt skullbolt = new SkullBolt(Necromancer.this.level(), (LivingEntity)Necromancer.this, vec3.normalize());
            skullbolt.setOwner((Entity)Necromancer.this);
            skullbolt.setPosRaw(d, e, f);
            Necromancer.this.level().addFreshEntity((Entity)skullbolt);
        }

        protected void performSpellCasting() {
            this.shootSkullAt(Necromancer.this.getTarget());
            Level level = Necromancer.this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double x = Necromancer.this.getX();
                double y = Necromancer.this.getY() + 2.5;
                double z = Necromancer.this.getZ();
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 40, 0.4, 0.4, 0.4, 0.15);
            }
            Necromancer.this.conjureSkullCooldown = 100;
        }

        private void shootSkullAt(LivingEntity target) {
            this.shootSkullAt(target.getX(), target.getY() + (double)target.getEyeHeight() * 0.5, target.getZ());
        }

        protected int getCastWarmupTime() {
            return 40;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 140;
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_ATTACK;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.BLINDNESS;
        }
    }

    class SummonUndeadGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private TargetingConditions closeVexPredicate;
        private int spellcount;

        SummonUndeadGoal() {
            super((SpellcasterIllager)Necromancer.this);
            this.closeVexPredicate = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            if (this.spellcount >= 4) {
                return false;
            }
            int i = ((ServerLevel)Necromancer.this.level()).getNearbyEntities(Zombie.class, this.closeVexPredicate, (LivingEntity)Necromancer.this, Necromancer.this.getBoundingBox().inflate(16.0)).size();
            return Necromancer.this.random.nextInt(5) + 1 > i;
        }

        protected int getCastingTime() {
            return 100;
        }

        protected int getCastingInterval() {
            return 340;
        }

        protected void performSpellCasting() {
            int spawnAmount = Necromancer.this.level().isDarkOutside() ? 4 : 2;
            for (int i = 0; i < spawnAmount; ++i) {
                this.summonUndead((EntityType<? extends Mob>)EntityType.ZOMBIE);
            }
            this.summonUndead((EntityType<? extends Mob>)EntityType.SKELETON);
            ++this.spellcount;
        }

        private void summonUndead(EntityType<? extends Mob> entityType) {
            ServerLevel serverLevel = (ServerLevel)Necromancer.this.level();
            BlockPos blockPos = Necromancer.this.blockPosition().offset(-2 + Necromancer.this.random.nextInt(5), 1, -2 + Necromancer.this.random.nextInt(5));
            Mob mob = (Mob)entityType.create((Level)serverLevel, EntitySpawnReason.MOB_SUMMONED);
            mob.snapTo(blockPos, 0.0f, 0.0f);
            mob.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(blockPos), EntitySpawnReason.MOB_SUMMONED, null);
            serverLevel.addFreshEntityWithPassengers((Entity)mob);
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSoundEvents.NECROMANCER_SUMMON_SOUND_EVENT.value();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }
}

