/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.IllagerInvasion;
import fuzs.illagerinvasion.config.ServerConfig;
import fuzs.illagerinvasion.init.ModEntityTypes;
import fuzs.illagerinvasion.init.ModSoundEvents;
import fuzs.illagerinvasion.util.TeleportUtil;
import fuzs.illagerinvasion.world.entity.monster.InvokerFangs;
import fuzs.illagerinvasion.world.entity.monster.Surrendered;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Invoker
extends SpellcasterIllager {
    private static final EntityDataAccessor<Boolean> DATA_IS_SHIELDED = SynchedEntityData.defineId(Invoker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final ServerBossEvent bossBar = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);
    public int areaDamageCooldown;
    public int teleportCooldown;
    public boolean isAoeCasting = false;
    public int fangaoecooldown;

    public Invoker(EntityType<? extends Invoker> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 50;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SpellcasterIllager.SpellcasterCastingSpellGoal((SpellcasterIllager)this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(5, (Goal)new AreaDamageGoal());
        this.goalSelector.addGoal(4, (Goal)new CastTeleportGoal());
        this.goalSelector.addGoal(5, (Goal)new SummonVexGoal());
        this.goalSelector.addGoal(5, (Goal)new ConjureAoeFangsGoal());
        this.goalSelector.addGoal(6, (Goal)new ConjureFangsGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public boolean isPowered() {
        return this.isShielded();
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity target) {
        if (!super.doHurtTarget(serverLevel, target)) {
            return false;
        }
        if (target instanceof LivingEntity) {
            ((LivingEntity)target).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0), (Entity)this);
        }
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_SHIELDED, (Object)false);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean("Invul", this.isShielded());
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setShielded(valueInput.getBooleanOr("Invul", false));
        if (this.hasCustomName()) {
            this.bossBar.setName(this.getDisplayName());
        }
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossBar.setName(this.getDisplayName());
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.EVOKER_CELEBRATE;
    }

    public boolean isShielded() {
        return (Boolean)this.entityData.get(DATA_IS_SHIELDED);
    }

    public void setShielded(boolean isShielded) {
        this.entityData.set(DATA_IS_SHIELDED, (Object)isShielded);
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        --this.teleportCooldown;
        --this.areaDamageCooldown;
        --this.fangaoecooldown;
        super.customServerAiStep(serverLevel);
        this.bossBar.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.isAoeCasting && this.isCastingSpell()) {
            this.sendSpellParticles(serverLevel, (ParticleOptions)ParticleTypes.SMOKE, 2, 0.06);
        }
        Vec3 deltaMovement = this.getDeltaMovement();
        if (!this.onGround() && deltaMovement.y < 0.0) {
            this.setDeltaMovement(deltaMovement.multiply(1.0, 0.6, 1.0));
        }
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.3, this.getZ(), 1, 0.2, 0.2, 0.2, 0.005);
    }

    private void sendSpellParticles(ServerLevel serverLevel, ParticleOptions particleTypes, int count, double speed) {
        float g = this.yBodyRot * ((float)Math.PI / 180) + Mth.cos((float)((float)this.tickCount * 0.6662f)) * 0.25f;
        float h = Mth.cos((float)g);
        float i = Mth.sin((float)g);
        serverLevel.sendParticles(particleTypes, this.getX() + (double)h * 0.6, this.getY() + 1.8, this.getZ() + (double)i, count, 0.0, 0.0, 0.0, speed);
        serverLevel.sendParticles(particleTypes, this.getX() - (double)h * 0.6, this.getY() + 1.8, this.getZ() - (double)i, count, 0.0, 0.0, 0.0, speed);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        if (((ServerConfig)IllagerInvasion.CONFIG.get(ServerConfig.class)).invokerBossBar) {
            this.bossBar.addPlayer(player);
        }
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        if (((ServerConfig)IllagerInvasion.CONFIG.get(ServerConfig.class)).invokerBossBar) {
            this.bossBar.removePlayer(player);
        }
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    public boolean considersEntityAsAlly(Entity entity) {
        Vex vex;
        if (entity == this) {
            return true;
        }
        if (super.considersEntityAsAlly(entity)) {
            return true;
        }
        if (entity instanceof Vex && (vex = (Vex)entity).getOwner() != null) {
            return this.considersEntityAsAlly((Entity)vex.getOwner());
        }
        return false;
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isAggressive()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float damageAmount) {
        if (damageSource.is(DamageTypeTags.IS_PROJECTILE)) {
            Entity entity = damageSource.getDirectEntity();
            if (entity != null && entity.getType().is(EntityTypeTags.IMPACT_PROJECTILES) && !this.isShielded() && this.random.nextInt(2) == 0) {
                this.playSound((SoundEvent)SoundEvents.SHIELD_BLOCK.value(), 1.0f, 0.8f + serverLevel.random.nextFloat() * 0.4f);
                this.setShielded(true);
            }
        } else if (this.isShielded() && this.random.nextInt(3) == 0) {
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY() + 1.0, this.getZ(), 30, 0.5, 0.7, 0.5, 0.5);
            this.playSound((SoundEvent)ModSoundEvents.INVOKER_SHIELD_BREAK_SOUND_EVENT.value(), 1.0f, 0.8f + serverLevel.random.nextFloat() * 0.4f);
            this.setShielded(false);
        }
        return super.hurtServer(serverLevel, damageSource, damageAmount);
    }

    public boolean isInvulnerableTo(ServerLevel serverLevel, DamageSource damageSource) {
        return super.isInvulnerableTo(serverLevel, damageSource) || damageSource.is(DamageTypeTags.WITCH_RESISTANT_TO) || this.isShielded() && damageSource.is(DamageTypeTags.IS_PROJECTILE);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.INVOKER_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.INVOKER_DEATH_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSoundEvents.INVOKER_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getCastingSoundEvent() {
        return (SoundEvent)ModSoundEvents.INVOKER_COMPLETE_CAST_SOUND_EVENT.value();
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public boolean canBeLeader() {
        return false;
    }

    public class AreaDamageGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public AreaDamageGoal() {
            super((SpellcasterIllager)Invoker.this);
        }

        public boolean canUse() {
            if (Invoker.this.getTarget() == null) {
                return false;
            }
            if (Invoker.this.areaDamageCooldown < 0) {
                Invoker.this.isAoeCasting = true;
                return true;
            }
            return false;
        }

        private void knockBack(Entity entity) {
            double d = entity.getX() - Invoker.this.getX();
            double e = entity.getZ() - Invoker.this.getZ();
            double f = Math.max(d * d + e * e, 0.001);
            entity.push(d / f * 6.0, 0.65, e / f * 6.0);
        }

        protected void knockback(LivingEntity target) {
            this.knockBack((Entity)target);
            target.hurtMarked = true;
        }

        public void stop() {
            Invoker.this.isAoeCasting = false;
            super.stop();
        }

        private void buff(LivingEntity entity) {
            this.knockback(entity);
            entity.hurtServer(AreaDamageGoal.getServerLevel((Level)Invoker.this.level()), Invoker.this.damageSources().indirectMagic((Entity)Invoker.this, (Entity)Invoker.this), 11.0f);
            double x = entity.getX();
            double y = entity.getY() + 2.0;
            double z = entity.getZ();
            ((ServerLevel)Invoker.this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 10, 0.2, 0.2, 0.2, 0.015);
        }

        protected void performSpellCasting() {
            Invoker.this.areaDamageCooldown = 300;
            Invoker.this.level().getEntitiesOfClass(LivingEntity.class, Invoker.this.getBoundingBox().inflate(6.0), entity -> !(entity instanceof AbstractIllager) && !(entity instanceof Surrendered) && !(entity instanceof Ravager) && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity)).forEach(this::buff);
            Invoker.this.isAoeCasting = false;
            double posx = Invoker.this.getX();
            double posy = Invoker.this.getY();
            double posz = Invoker.this.getZ();
            ((ServerLevel)Invoker.this.level()).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, posx, posy + 1.0, posz, 350, 1.0, 0.8, 1.0, 0.3);
        }

        protected int getCastWarmupTime() {
            return 50;
        }

        protected int getCastingTime() {
            return 50;
        }

        protected int getCastingInterval() {
            return 400;
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSoundEvents.INVOKER_BIG_CAST_SOUND_EVENT.value();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.BLINDNESS;
        }
    }

    public class CastTeleportGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public CastTeleportGoal() {
            super((SpellcasterIllager)Invoker.this);
        }

        public boolean canUse() {
            if (Invoker.this.getTarget() == null) {
                return false;
            }
            if (Invoker.this.isCastingSpell()) {
                return false;
            }
            return Invoker.this.teleportCooldown < 0 && !this.getTargets().isEmpty();
        }

        private List<LivingEntity> getTargets() {
            return Invoker.this.level().getEntitiesOfClass(LivingEntity.class, Invoker.this.getBoundingBox().inflate(6.0), entity -> entity instanceof Player && !((Player)entity).getAbilities().instabuild || entity instanceof IronGolem);
        }

        public boolean canContinueToUse() {
            return !this.getTargets().isEmpty();
        }

        public void stop() {
            super.stop();
        }

        public void start() {
            super.start();
            Invoker.this.teleportCooldown = 180;
        }

        protected void performSpellCasting() {
            double x = Invoker.this.getX();
            double y = Invoker.this.getY() + 1.0;
            double z = Invoker.this.getZ();
            if (Invoker.this.level() instanceof ServerLevel) {
                ((ServerLevel)Invoker.this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 30, 0.3, 0.5, 0.3, 0.015);
            }
            TeleportUtil.tryRandomTeleport((LivingEntity)Invoker.this);
        }

        protected int getCastWarmupTime() {
            return 30;
        }

        protected int getCastingTime() {
            return 30;
        }

        protected int getCastingInterval() {
            return 400;
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSoundEvents.INVOKER_TELEPORT_CAST_SOUND_EVENT.value();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.BLINDNESS;
        }
    }

    class SummonVexGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private static final TargetingConditions CLOSE_VEX_PREDICATE = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();

        SummonVexGoal() {
            super((SpellcasterIllager)Invoker.this);
        }

        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            return ((ServerLevel)Invoker.this.level()).getNearbyEntities(Surrendered.class, CLOSE_VEX_PREDICATE, (LivingEntity)Invoker.this, Invoker.this.getBoundingBox().inflate(20.0)).size() < 3;
        }

        protected int getCastingTime() {
            return 100;
        }

        protected int getCastingInterval() {
            return 340;
        }

        protected void performSpellCasting() {
            ServerLevel serverLevel = (ServerLevel)Invoker.this.level();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockPos = Invoker.this.blockPosition().offset(-2 + Invoker.this.random.nextInt(5), 1, -2 + Invoker.this.random.nextInt(5));
                Surrendered surrendered = (Surrendered)((EntityType)ModEntityTypes.SURRENDERED_ENTITY_TYPE.value()).create(Invoker.this.level(), EntitySpawnReason.MOB_SUMMONED);
                if (surrendered == null) continue;
                surrendered.snapTo(blockPos, 0.0f, 0.0f);
                surrendered.finalizeSpawn((ServerLevelAccessor)serverLevel, Invoker.this.level().getCurrentDifficultyAt(blockPos), EntitySpawnReason.MOB_SUMMONED, null);
                surrendered.setOwner((Mob)Invoker.this);
                surrendered.setBoundOrigin(blockPos);
                surrendered.setLimitedLife(20 * (30 + Invoker.this.random.nextInt(90)));
                serverLevel.addFreshEntityWithPassengers((Entity)surrendered);
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSoundEvents.INVOKER_SUMMON_CAST_SOUND_EVENT.value();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    public class ConjureAoeFangsGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public ConjureAoeFangsGoal() {
            super((SpellcasterIllager)Invoker.this);
        }

        public boolean canUse() {
            if (Invoker.this.getTarget() == null) {
                return false;
            }
            if (this.getTargets().isEmpty()) {
                return false;
            }
            if (Invoker.this.isCastingSpell()) {
                return false;
            }
            return Invoker.this.fangaoecooldown < 0;
        }

        private List<LivingEntity> getTargets() {
            return Invoker.this.level().getEntitiesOfClass(LivingEntity.class, Invoker.this.getBoundingBox().inflate(18.0), entity -> !(entity instanceof Monster));
        }

        private void conjureFangs(double x, double z, double maxY, double y, float yaw, int warmup) {
            ServerLevel serverLevel = ConjureAoeFangsGoal.getServerLevel((Level)Invoker.this.level());
            BlockPos currentPos = BlockPos.containing((double)x, (double)y, (double)z);
            int minY = Mth.floor((double)maxY) - 1;
            while (currentPos.getY() >= minY) {
                VoxelShape shape;
                BlockPos belowPos = currentPos.below();
                if (!serverLevel.getBlockState(belowPos).isFaceSturdy((BlockGetter)serverLevel, belowPos, Direction.UP)) {
                    currentPos = belowPos;
                    continue;
                }
                double verticalOffset = 0.0;
                if (!serverLevel.isEmptyBlock(currentPos) && !(shape = serverLevel.getBlockState(currentPos).getCollisionShape((BlockGetter)serverLevel, currentPos)).isEmpty()) {
                    verticalOffset = shape.max(Direction.Axis.Y);
                }
                serverLevel.addFreshEntity((Entity)new InvokerFangs((Level)serverLevel, x, (double)currentPos.getY() + 0.2 + verticalOffset, z, yaw, warmup, (LivingEntity)Invoker.this));
                break;
            }
        }

        protected void performSpellCasting() {
            for (LivingEntity livingEntity : this.getTargets()) {
                double d = Math.min(livingEntity.getY(), Invoker.this.getY());
                double e = Math.max(livingEntity.getY(), Invoker.this.getY()) + 1.0;
                float f = (float)Mth.atan2((double)(livingEntity.getZ() - Invoker.this.getZ()), (double)(livingEntity.getX() - Invoker.this.getX()));
                for (int i = 0; i < 5; ++i) {
                    float g = f + (float)i * (float)Math.PI * 0.4f;
                    this.conjureFangs(livingEntity.getX() + (double)Mth.cos((float)g) * 1.5, livingEntity.getZ() + (double)Mth.sin((float)g) * 1.5, d, e, g, 4);
                }
            }
            Invoker.this.fangaoecooldown = 100;
        }

        protected int getCastingTime() {
            return 40;
        }

        protected int getCastingInterval() {
            return 100;
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSoundEvents.INVOKER_FANGS_CAST_SOUND_EVENT.value();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    class ConjureFangsGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        ConjureFangsGoal() {
            super((SpellcasterIllager)Invoker.this);
        }

        protected int getCastingTime() {
            return 40;
        }

        protected int getCastingInterval() {
            return 100;
        }

        protected void performSpellCasting() {
            LivingEntity livingEntity = Invoker.this.getTarget();
            double d = Math.min(livingEntity.getY(), Invoker.this.getY());
            double e = Math.max(livingEntity.getY(), Invoker.this.getY()) + 1.0;
            float f = (float)Mth.atan2((double)(livingEntity.getZ() - Invoker.this.getZ()), (double)(livingEntity.getX() - Invoker.this.getX()));
            if (Invoker.this.distanceToSqr((Entity)livingEntity) < 9.0) {
                float g;
                int i;
                for (i = 0; i < 5; ++i) {
                    g = f + (float)i * (float)Math.PI * 0.4f;
                    this.conjureFangs(Invoker.this.getX() + (double)Mth.cos((float)g) * 1.5, Invoker.this.getZ() + (double)Mth.sin((float)g) * 1.5, d, e, g, 0);
                }
                for (i = 0; i < 8; ++i) {
                    g = f + (float)i * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.conjureFangs(Invoker.this.getX() + (double)Mth.cos((float)g) * 2.5, Invoker.this.getZ() + (double)Mth.sin((float)g) * 2.5, d, e, g, 3);
                }
                for (i = 0; i < 8; ++i) {
                    g = f + (float)i * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.conjureFangs(Invoker.this.getX() + (double)Mth.cos((float)g) * 3.5, Invoker.this.getZ() + (double)Mth.sin((float)g) * 2.5, d, e, g, 3);
                }
            } else {
                double h;
                int i;
                for (i = 0; i < 16; ++i) {
                    h = 1.25 * (double)(i + 1);
                    this.conjureFangs(Invoker.this.getX() + (double)Mth.cos((float)f) * h, Invoker.this.getZ() + (double)Mth.sin((float)f) * h, d, e, f, i);
                }
                for (i = 0; i < 16; ++i) {
                    h = 1.25 * (double)(i + 1);
                    this.conjureFangs(Invoker.this.getX() + (double)Mth.cos((float)(f + 0.4f)) * h, Invoker.this.getZ() + (double)Mth.sin((float)(f + 0.3f)) * h, d, e, f, i);
                }
                for (i = 0; i < 16; ++i) {
                    h = 1.25 * (double)(i + 1);
                    this.conjureFangs(Invoker.this.getX() + (double)Mth.cos((float)(f - 0.4f)) * h, Invoker.this.getZ() + (double)Mth.sin((float)(f - 0.3f)) * h, d, e, f, i);
                }
            }
        }

        private void conjureFangs(double x, double z, double maxY, double y, float yaw, int warmup) {
            ServerLevel serverLevel = ConjureFangsGoal.getServerLevel((Level)Invoker.this.level());
            BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
            int minY = Mth.floor((double)maxY) - 1;
            while (blockPos.getY() >= minY) {
                BlockPos blockPosBelow = blockPos.below();
                if (serverLevel.getBlockState(blockPosBelow).isFaceSturdy((BlockGetter)serverLevel, blockPosBelow, Direction.UP)) {
                    VoxelShape shape;
                    double verticalOffset = 0.0;
                    if (!serverLevel.isEmptyBlock(blockPos) && !(shape = serverLevel.getBlockState(blockPos).getCollisionShape((BlockGetter)serverLevel, blockPos)).isEmpty()) {
                        verticalOffset = shape.max(Direction.Axis.Y);
                    }
                    serverLevel.addFreshEntity((Entity)new InvokerFangs((Level)serverLevel, x, (double)blockPos.getY() + 0.2 + verticalOffset, z, yaw, warmup, (LivingEntity)Invoker.this));
                    break;
                }
                blockPos = blockPosBelow;
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSoundEvents.INVOKER_FANGS_CAST_SOUND_EVENT.value();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }
}

