/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.ai.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.Monster;

public class RangedBowAttackWithoutStrafingGoal<T extends Monster>
extends RangedBowAttackGoal<T> {
    private final T mob;
    private int attackIntervalBase;

    public RangedBowAttackWithoutStrafingGoal(T mob, double speedModifier, int attackIntervalMin, float attackRadius) {
        super(mob, speedModifier, attackIntervalMin, attackRadius);
        this.mob = mob;
        this.attackIntervalBase = attackIntervalMin;
    }

    public void setMinAttackInterval(int attackCooldown) {
        super.setMinAttackInterval(attackCooldown);
        this.attackIntervalBase = attackCooldown;
    }

    public void tick() {
        this.strafingTime = Integer.MIN_VALUE;
        LivingEntity livingEntity = this.mob.getTarget();
        if (livingEntity != null) {
            double distanceToTargetSqr = this.mob.distanceToSqr((Entity)livingEntity);
            this.attackIntervalMin = this.attackIntervalBase - (int)((1.0 - Math.min(distanceToTargetSqr / (double)this.attackRadiusSqr, 1.0)) * 20.0);
        }
        super.tick();
    }
}

