/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.illagerinvasion.IllagerInvasion;
import fuzs.illagerinvasion.client.model.CustomIllagerModel;
import fuzs.illagerinvasion.client.model.geom.ModModelLayers;
import fuzs.illagerinvasion.client.render.entity.state.SpellcasterIllagerRenderState;
import fuzs.illagerinvasion.world.entity.monster.Provoker;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.IllagerRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.AbstractIllager;

public class ProvokerRenderer
extends IllagerRenderer<Provoker, SpellcasterIllagerRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = IllagerInvasion.id("textures/entity/provoker.png");

    public ProvokerRenderer(EntityRendererProvider.Context context) {
        super(context, new CustomIllagerModel(context.bakeLayer(ModModelLayers.PROVOKER)), 0.5f);
        this.addLayer((RenderLayer)new ItemInHandLayer<SpellcasterIllagerRenderState, IllagerModel<SpellcasterIllagerRenderState>>(this, (RenderLayerParent)this){

            public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, SpellcasterIllagerRenderState renderState, float yRot, float xRot) {
                if (renderState.isAggressive || renderState.isCastingSpell) {
                    super.submit(poseStack, nodeCollector, packedLight, (ArmedEntityRenderState)renderState, yRot, xRot);
                }
            }
        });
        ((IllagerModel)this.model).getHat().visible = true;
    }

    public SpellcasterIllagerRenderState createRenderState() {
        return new SpellcasterIllagerRenderState();
    }

    public void extractRenderState(Provoker entity, SpellcasterIllagerRenderState reusedState, float partialTick) {
        super.extractRenderState((AbstractIllager)entity, (IllagerRenderState)reusedState, partialTick);
        reusedState.isCastingSpell = entity.isCastingSpell();
    }

    public ResourceLocation getTextureLocation(SpellcasterIllagerRenderState renderState) {
        return TEXTURE_LOCATION;
    }
}

