/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.illagerinvasion.IllagerInvasion;
import fuzs.illagerinvasion.client.model.CustomIllagerModel;
import fuzs.illagerinvasion.client.model.geom.ModModelLayers;
import fuzs.illagerinvasion.client.render.entity.layers.IllagerArmorLayer;
import fuzs.illagerinvasion.client.render.entity.state.NecromancerRenderState;
import fuzs.illagerinvasion.world.entity.monster.Necromancer;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.IllagerRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.AbstractIllager;

public class NecromancerRenderer
extends IllagerRenderer<Necromancer, NecromancerRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = IllagerInvasion.id("textures/entity/necromancer.png");
    private static final ResourceLocation ARMOR_TEXTURE_LOCATION = IllagerInvasion.id("textures/entity/necromancer_armor.png");

    public NecromancerRenderer(EntityRendererProvider.Context context) {
        super(context, new CustomIllagerModel(context.bakeLayer(ModModelLayers.NECROMANCER)), 0.5f);
        this.addLayer((RenderLayer)new IllagerArmorLayer<NecromancerRenderState, IllagerModel<NecromancerRenderState>>(this, (RenderLayerParent)this, new CustomIllagerModel(context.bakeLayer(ModModelLayers.NECROMANCER_ARMOR))){

            protected ResourceLocation getTextureLocation() {
                return ARMOR_TEXTURE_LOCATION;
            }
        });
        this.addLayer((RenderLayer)new ItemInHandLayer<NecromancerRenderState, IllagerModel<NecromancerRenderState>>(this, (RenderLayerParent)this){

            public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, NecromancerRenderState renderState, float yRot, float xRot) {
                if (renderState.isCastingSpell) {
                    super.submit(poseStack, nodeCollector, packedLight, (ArmedEntityRenderState)renderState, yRot, xRot);
                }
            }
        });
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition2 = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, cubeDeformation), PartPose.ZERO);
        partDefinition2.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 12.0f, 8.0f, cubeDeformation.extend(0.45f)), PartPose.ZERO);
        partDefinition2.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, cubeDeformation).texOffs(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, cubeDeformation.extend(0.5f)), PartPose.ZERO);
        PartDefinition partDefinition3 = partDefinition.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(44, 22).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, cubeDeformation).texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partDefinition3.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, cubeDeformation), PartPose.ZERO);
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 46).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 46).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void extractRenderState(Necromancer entity, NecromancerRenderState reusedState, float partialTick) {
        super.extractRenderState((AbstractIllager)entity, (IllagerRenderState)reusedState, partialTick);
        reusedState.isPowered = entity.isPowered();
        reusedState.isCastingSpell = entity.isCastingSpell();
    }

    public NecromancerRenderState createRenderState() {
        return new NecromancerRenderState();
    }

    public ResourceLocation getTextureLocation(NecromancerRenderState renderState) {
        return TEXTURE_LOCATION;
    }
}

