/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.illagerinvasion.IllagerInvasion;
import fuzs.illagerinvasion.client.model.InvokerModel;
import fuzs.illagerinvasion.client.model.geom.ModModelLayers;
import fuzs.illagerinvasion.client.render.entity.layers.IllagerArmorLayer;
import fuzs.illagerinvasion.client.render.entity.layers.InvokerGoldLayer;
import fuzs.illagerinvasion.client.render.entity.state.InvokerRenderState;
import fuzs.illagerinvasion.world.entity.monster.Invoker;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.IllagerRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.AbstractIllager;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class InvokerRenderer
extends IllagerRenderer<Invoker, InvokerRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = IllagerInvasion.id("textures/entity/invoker.png");
    private static final ResourceLocation ARMOR_TEXTURE_LOCATION = ResourceLocationHelper.withDefaultNamespace((String)"textures/entity/wither/wither_armor.png");

    public InvokerRenderer(EntityRendererProvider.Context context) {
        super(context, (IllagerModel)new InvokerModel(context.bakeLayer(ModModelLayers.INVOKER)), 0.0f);
        this.addLayer((RenderLayer)new InvokerGoldLayer((RenderLayerParent<InvokerRenderState, IllagerModel<InvokerRenderState>>)this));
        this.addLayer((RenderLayer)new IllagerArmorLayer<InvokerRenderState, IllagerModel<InvokerRenderState>>(this, (RenderLayerParent)this, (IllagerModel)new InvokerModel(context.bakeLayer(ModModelLayers.INVOKER_ARMOR))){

            protected ResourceLocation getTextureLocation() {
                return ARMOR_TEXTURE_LOCATION;
            }
        });
        ((IllagerModel)this.model).getHat().visible = true;
    }

    public InvokerRenderState createRenderState() {
        return new InvokerRenderState();
    }

    protected void setupRotations(InvokerRenderState renderState, PoseStack poseStack, float bodyRot, float scale) {
        super.setupRotations((LivingEntityRenderState)renderState, poseStack, bodyRot, scale);
        float rotation = Mth.sin((float)(renderState.ageInTicks * 0.1f)) * ((float)Math.PI / 180);
        poseStack.mulPose((Quaternionfc)new Quaternionf().rotationZYX(rotation, 0.0f, -rotation));
        poseStack.translate(0.0f, 0.3f + rotation, 0.0f);
    }

    public void extractRenderState(Invoker entity, InvokerRenderState reusedState, float partialTick) {
        super.extractRenderState((AbstractIllager)entity, (IllagerRenderState)reusedState, partialTick);
        reusedState.isPowered = entity.isPowered();
        if (!reusedState.isRiding) {
            reusedState.floatAnimationSpeed = reusedState.walkAnimationSpeed;
            reusedState.walkAnimationPos = 0.0f;
            reusedState.walkAnimationSpeed = 0.0f;
        }
    }

    public ResourceLocation getTextureLocation(InvokerRenderState renderState) {
        return TEXTURE_LOCATION;
    }
}

