/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.illagerinvasion.IllagerInvasion;
import fuzs.illagerinvasion.client.model.InvokerFangsModel;
import fuzs.illagerinvasion.client.model.geom.ModModelLayers;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EvokerFangsRenderer;
import net.minecraft.client.renderer.entity.state.EvokerFangsRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionfc;

public class InvokerFangsRenderer
extends EvokerFangsRenderer {
    private static final ResourceLocation TEXTURE_LOCATION = IllagerInvasion.id("textures/entity/invoker_fangs.png");
    private final InvokerFangsModel model;

    public InvokerFangsRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new InvokerFangsModel(context.bakeLayer(ModModelLayers.INVOKER_FANGS));
    }

    public void submit(EvokerFangsRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.biteProgress != 0.0f) {
            poseStack.pushPose();
            poseStack.scale(1.15f, 1.15f, 1.15f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f - renderState.yRot));
            float scale = 2.0f * (renderState.biteProgress > 0.9f ? (1.0f - renderState.biteProgress) / 0.1f : 1.0f);
            poseStack.scale(-scale, -scale, scale);
            poseStack.translate(0.0f, -0.626f, 0.0f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            nodeCollector.submitModel((Model)this.model, (Object)renderState, poseStack, this.model.renderType(TEXTURE_LOCATION), renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.outlineColor, null);
            poseStack.popPose();
            super.submit(renderState, poseStack, nodeCollector, cameraRenderState);
        }
    }
}

