/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.illagerinvasion.IllagerInvasion;
import fuzs.illagerinvasion.client.model.CustomIllagerModel;
import fuzs.illagerinvasion.client.model.geom.ModModelLayers;
import fuzs.illagerinvasion.client.render.entity.state.ArchivistRenderState;
import fuzs.illagerinvasion.world.entity.monster.Archivist;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.IllagerRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.AbstractIllager;
import org.joml.Quaternionfc;

public class ArchivistRenderer
extends IllagerRenderer<Archivist, ArchivistRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = IllagerInvasion.id("textures/entity/archivist.png");
    private static final Material BOOK_LOCATION = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocationHelper.withDefaultNamespace((String)"entity/enchanting_table_book"));
    private final MaterialSet materials;

    public ArchivistRenderer(final EntityRendererProvider.Context context) {
        super(context, new CustomIllagerModel(context.bakeLayer(ModModelLayers.ARCHIVIST)), 0.5f);
        this.materials = context.getMaterials();
        this.addLayer((RenderLayer)new ItemInHandLayer<ArchivistRenderState, IllagerModel<ArchivistRenderState>>((RenderLayerParent)this){
            private final BookModel book;
            {
                super(renderer);
                this.book = new BookModel(context.bakeLayer(ModModelLayers.ARCHIVIST_BOOK));
            }

            public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, ArchivistRenderState renderState, float yRot, float xRot) {
                if (renderState.isCastingSpell) {
                    super.submit(poseStack, nodeCollector, packedLight, (ArmedEntityRenderState)renderState, yRot, xRot);
                }
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.362f, -0.5f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
                if (renderState.isCastingSpell) {
                    poseStack.translate(-0.4f, 0.0f, 0.0f);
                    poseStack.mulPose((Quaternionfc)Axis.ZN.rotationDegrees(30.0f));
                }
                nodeCollector.submitModel((Model)this.book, (Object)renderState.book, poseStack, BOOK_LOCATION.renderType(RenderType::entitySolid), renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, ArchivistRenderer.this.materials.get(BOOK_LOCATION), renderState.outlineColor, null);
                poseStack.popPose();
            }
        });
        ((IllagerModel)this.model).getHat().visible = true;
    }

    public ArchivistRenderState createRenderState() {
        return new ArchivistRenderState();
    }

    public void extractRenderState(Archivist entity, ArchivistRenderState renderState, float partialTick) {
        super.extractRenderState((AbstractIllager)entity, (IllagerRenderState)renderState, partialTick);
        renderState.isCastingSpell = entity.isCastingSpell();
        renderState.book = renderState.isCastingSpell ? new BookModel.State(0.0f, 10.0f + Mth.cos((float)renderState.ageInTicks) * 0.55f, 0.0f, 1.05f) : new BookModel.State(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(ArchivistRenderState renderState) {
        return TEXTURE_LOCATION;
    }
}

