/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.illagerinvasion.IllagerInvasion;
import fuzs.illagerinvasion.client.model.CustomIllagerModel;
import fuzs.illagerinvasion.client.model.geom.ModModelLayers;
import fuzs.illagerinvasion.world.entity.monster.Alchemist;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.IllagerRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.resources.ResourceLocation;

public class AlchemistRenderer
extends IllagerRenderer<Alchemist, IllagerRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = IllagerInvasion.id("textures/entity/alchemist.png");

    public AlchemistRenderer(EntityRendererProvider.Context context) {
        super(context, new CustomIllagerModel(context.bakeLayer(ModModelLayers.ALCHEMIST)), 0.5f);
        this.addLayer((RenderLayer)new ItemInHandLayer<IllagerRenderState, IllagerModel<IllagerRenderState>>(this, (RenderLayerParent)this){

            public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, IllagerRenderState renderState, float yRot, float xRot) {
                if (renderState.isAggressive) {
                    super.submit(poseStack, nodeCollector, packedLight, (ArmedEntityRenderState)renderState, yRot, xRot);
                }
            }
        });
        ((IllagerModel)this.model).getHat().visible = true;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = IllagerModel.createBodyLayer().mesh;
        PartDefinition partDefinition = meshDefinition.getRoot().getChild("head").getChild("hat");
        partDefinition.addOrReplaceChild("brim", CubeListBuilder.create().texOffs(69, 47).addBox(-8.0f, -8.0f, -6.0f, 16.0f, 16.0f, 1.0f), PartPose.rotation((float)-1.5707964f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    public IllagerRenderState createRenderState() {
        return new IllagerRenderState();
    }

    public ResourceLocation getTextureLocation(IllagerRenderState renderState) {
        return TEXTURE_LOCATION;
    }
}

