/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EvokerFangsRenderState;
import net.minecraft.util.Mth;

public class InvokerFangsModel
extends EntityModel<EvokerFangsRenderState> {
    private final ModelPart base;
    private final ModelPart upperJaw;
    private final ModelPart lowerJaw;
    private final ModelPart spike1;
    private final ModelPart spike2;
    private final ModelPart spike3;
    private final ModelPart spike4;

    public InvokerFangsModel(ModelPart root) {
        super(root);
        this.base = root.getChild("base");
        this.upperJaw = root.getChild("upper_jaw");
        this.lowerJaw = root.getChild("lower_jaw");
        this.spike1 = root.getChild("spike1");
        this.spike2 = root.getChild("spike2");
        this.spike3 = root.getChild("spike3");
        this.spike4 = root.getChild("spike4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        CubeListBuilder modelPartBuilder2 = CubeListBuilder.create().texOffs(100, 0).addBox(-0.2f, 0.0f, -0.1f, 6.0f, 25.0f, 0.0f);
        modelPartData.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 10.0f, 12.0f, 10.0f), PartPose.offset((float)-5.0f, (float)24.0f, (float)-5.0f));
        modelPartData.addOrReplaceChild("spike1", modelPartBuilder2, PartPose.offset((float)-0.2f, (float)0.0f, (float)-0.1f));
        modelPartData.addOrReplaceChild("spike2", modelPartBuilder2, PartPose.offset((float)-0.2f, (float)0.0f, (float)-0.1f));
        modelPartData.addOrReplaceChild("spike3", modelPartBuilder2, PartPose.offset((float)-0.2f, (float)0.0f, (float)-0.1f));
        modelPartData.addOrReplaceChild("spike4", modelPartBuilder2, PartPose.offset((float)-0.2f, (float)0.0f, (float)-0.1f));
        CubeListBuilder modelPartBuilder = CubeListBuilder.create().texOffs(40, 0).addBox(0.0f, 0.0f, 0.0f, 4.0f, 14.0f, 8.0f);
        modelPartData.addOrReplaceChild("upper_jaw", modelPartBuilder, PartPose.offset((float)1.5f, (float)24.0f, (float)-4.0f));
        modelPartData.addOrReplaceChild("lower_jaw", modelPartBuilder, PartPose.offsetAndRotation((float)-1.5f, (float)24.0f, (float)4.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)64);
    }

    public void setupAnim(EvokerFangsRenderState renderState) {
        super.setupAnim((Object)renderState);
        float biteProgress = renderState.biteProgress;
        float jawRotationProgress = Math.min(biteProgress * 2.0f, 1.0f);
        jawRotationProgress = 1.0f - jawRotationProgress * jawRotationProgress * jawRotationProgress;
        this.upperJaw.zRot = -Mth.cos((float)(jawRotationProgress * 1.8f)) - 9.56576f;
        this.lowerJaw.zRot = Mth.cos((float)(jawRotationProgress * 1.8f)) + 9.56576f;
        float h = (biteProgress + Mth.sin((float)(biteProgress * 2.7f))) * 0.6f * 12.0f;
        this.spike1.yRot = 1.0f;
        this.spike2.yRot = -1.0f;
        this.spike3.yRot = -2.0f;
        this.spike4.yRot = 2.0f;
        this.lowerJaw.y = this.upperJaw.y = 24.0f - h;
        this.base.y = this.upperJaw.y;
        this.spike1.y = this.upperJaw.y * Mth.cos((float)(h / 4.0f)) + 1.6f;
        this.spike2.y = this.upperJaw.y * Mth.cos((float)(h / 4.0f)) + 1.6f;
        this.spike3.y = this.upperJaw.y * Mth.cos((float)(h / 4.0f)) + 1.6f;
        this.spike4.y = this.upperJaw.y * Mth.cos((float)(h / 4.0f)) + 1.6f;
    }
}

