/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.mixins.server;

import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.NCRConfig;
import io.netty.channel.ChannelFutureListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerCommonPacketListenerImpl.class})
public abstract class MixinServerCommonPacketListenerImpl {
    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSend(Packet<?> packet, CallbackInfo info) {
        MixinServerCommonPacketListenerImpl self = this;
        if (self instanceof ServerGamePacketListenerImpl) {
            ClientboundPlayerChatPacket chat;
            ServerGamePacketListenerImpl listener = (ServerGamePacketListenerImpl)self;
            if (NCRConfig.getCommon().enableDebugLog() && packet instanceof ClientboundPlayerChatPacket) {
                chat = (ClientboundPlayerChatPacket)packet;
                NCRCore.LOGGER.info("Sending message: {}", chat.unsignedContent() != null ? chat.unsignedContent() : chat.body().content());
            }
            if (NCRConfig.getCommon().convertToGameMessage() && packet instanceof ClientboundPlayerChatPacket) {
                chat = (ClientboundPlayerChatPacket)packet;
                packet = new ClientboundSystemChatPacket(chat.chatType().decorate((Component)(chat.unsignedContent() != null ? chat.unsignedContent() : Component.literal((String)chat.body().content()))), false);
                info.cancel();
                listener.send((Packet)packet);
            }
        }
    }

    @Inject(method={"Lnet/minecraft/server/network/ServerCommonPacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;Lio/netty/channel/ChannelFutureListener;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSend(Packet<?> packet, @Nullable ChannelFutureListener channelFutureListener, CallbackInfo info) {
        MixinServerCommonPacketListenerImpl self = this;
        if (self instanceof ServerGamePacketListenerImpl) {
            ClientboundPlayerChatPacket chat;
            ServerGamePacketListenerImpl listener = (ServerGamePacketListenerImpl)self;
            if (NCRConfig.getCommon().enableDebugLog() && packet instanceof ClientboundPlayerChatPacket) {
                chat = (ClientboundPlayerChatPacket)packet;
                NCRCore.LOGGER.info("Sending message: {}", chat.unsignedContent() != null ? chat.unsignedContent() : chat.body().content());
            }
            if (NCRConfig.getCommon().convertToGameMessage() && packet instanceof ClientboundPlayerChatPacket) {
                chat = (ClientboundPlayerChatPacket)packet;
                if (channelFutureListener != null) {
                    info.cancel();
                    listener.send((Packet)chat);
                }
            }
        }
    }
}

