/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.gui;

import com.aizistral.nochatreports.common.gui.AdvancedTooltip;
import com.aizistral.nochatreports.common.gui.AdvancedWidgetTooltipHolder;
import com.aizistral.nochatreports.common.gui.SwitchableSprites;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetTooltipHolder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

@Environment(value=EnvType.CLIENT)
public class AdvancedImageButton
extends ImageButton {
    protected final Screen parent;
    protected final SwitchableSprites switchable;

    public AdvancedImageButton(int x, int y, int xSize, int ySize, SwitchableSprites sprites, Button.OnPress onPress, Component name, Screen parent) {
        super(x, y, xSize, ySize, sprites.getDefault(), onPress, name);
        this.parent = parent;
        this.switchable = sprites;
    }

    public void useSprites(int index) {
        this.switchable.setIndex(index);
    }

    public int getSpritesIndex() {
        return this.switchable.getIndex();
    }

    public ResourceLocation getCurrentTexture() {
        return this.switchable.getCurrent().get(this.isActive(), this.isHoveredOrFocused());
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        AdvancedWidgetTooltipHolder holder;
        WidgetTooltipHolder widgetTooltipHolder;
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getCurrentTexture(), this.getX(), this.getY(), this.width, this.height);
        if (this.isHovered && (widgetTooltipHolder = this.tooltip) instanceof AdvancedWidgetTooltipHolder && (holder = (AdvancedWidgetTooltipHolder)widgetTooltipHolder).hasCustomRender()) {
            holder.doCustomRender(this.parent, graphics, mouseX, mouseY, holder.createTooltipPositioner(this.getRectangle(), this.isHovered(), this.isFocused()));
        }
    }

    public void setTooltip(Tooltip tooltip) {
        if (tooltip instanceof AdvancedTooltip) {
            this.tooltip = new AdvancedWidgetTooltipHolder();
        }
        super.setTooltip(tooltip);
    }
}

