/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client;

import com.mrcrayfish.framework.api.event.client.FrameworkClientConnectionEvents;
import com.mrcrayfish.framework.api.event.client.FrameworkClientTickEvents;
import com.mrcrayfish.framework.api.event.client.FrameworkInputEvents;
import com.mrcrayfish.framework.api.event.client.FrameworkScreenEvents;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

public class ClientNeoForgeEvents {
    @SubscribeEvent
    public void onClientPlayerLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        FrameworkClientConnectionEvents.LOGGING_IN.post().handle(event.getPlayer(), event.getMultiPlayerGameMode(), event.getConnection());
    }

    @SubscribeEvent
    public void onClientPlayerLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        FrameworkClientConnectionEvents.LOGGING_OUT.post().handle(event.getConnection());
    }

    @SubscribeEvent
    public void onAfterDrawBackground(ContainerScreenEvent.Render.Background event) {
        FrameworkScreenEvents.AFTER_DRAW_CONTAINER_BACKGROUND.post().handle(event.getContainerScreen(), event.getGuiGraphics(), event.getMouseX(), event.getMouseY());
    }

    @SubscribeEvent
    public void onClientTickPre(ClientTickEvent.Pre event) {
        FrameworkClientTickEvents.START_CLIENT.post().handle();
    }

    @SubscribeEvent
    public void onClientTickPost(ClientTickEvent.Post event) {
        FrameworkClientTickEvents.END_CLIENT.post().handle();
    }

    @SubscribeEvent
    public void onKey(InputEvent.Key event) {
        FrameworkInputEvents.KEY.post().handle(event.getKey(), event.getScanCode(), event.getAction(), event.getModifiers());
        FrameworkInputEvents.KEY_PRESS.post().handle(event.getAction(), event.getKeyEvent());
    }

    @SubscribeEvent
    public void onInteraction(InputEvent.InteractionKeyMappingTriggered event) {
        if (FrameworkInputEvents.INTERACTION.post().handle(event.isAttack(), event.isUseItem(), event.isPickBlock(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onScreenInit(ScreenEvent.Init.Post event) {
        List<AbstractWidget> widgets = event.getListenersList().stream().filter(listener -> listener instanceof AbstractWidget).map(listener -> (AbstractWidget)listener).toList();
        FrameworkScreenEvents.INIT.post().handle(event.getScreen(), widgets, arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0), arg_0 -> ((ScreenEvent.Init.Post)event).removeListener(arg_0));
    }

    @SubscribeEvent
    public void onRenderFramePre(RenderFrameEvent.Pre event) {
        FrameworkClientTickEvents.START_RENDER.post().handle(event.getPartialTick());
    }

    @SubscribeEvent
    public void onRenderFramePost(RenderFrameEvent.Post event) {
        FrameworkClientTickEvents.END_RENDER.post().handle(event.getPartialTick());
    }

    @SubscribeEvent
    public void onScreenRenderPre(ScreenEvent.Render.Pre event) {
        FrameworkScreenEvents.BEFORE_DRAW.post().handle(event.getScreen(), event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick());
    }

    @SubscribeEvent
    public void onScreenRenderPost(ScreenEvent.Render.Post event) {
        FrameworkScreenEvents.AFTER_DRAW.post().handle(event.getScreen(), event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onScreenOpen(ScreenEvent.Opening event) {
        FrameworkScreenEvents.OPENED.post().handle(event.getNewScreen());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onScreenOpen(ScreenEvent.Closing event) {
        FrameworkScreenEvents.CLOSED.post().handle(event.getScreen());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onInputUpdate(MovementInputUpdateEvent event) {
        FrameworkInputEvents.CLIENT_INPUT_UPDATE.post().handle(event.getEntity(), event.getInput());
    }
}

