/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.model.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrcrayfish.framework.api.client.model.FrameworkBakedModel;
import com.mrcrayfish.framework.platform.ClientServices;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public class StandaloneModelRenderer {
    private static final Direction[] DIRECTIONS = Direction.values();

    public static void draw(FrameworkBakedModel model, PoseStack stack, MultiBufferSource source, float red, float green, float blue, int light, int overlay) {
        StandaloneModelRenderer.draw(model.quads(), model.layer(), stack, source, red, green, blue, light, overlay);
    }

    public static void draw(BlockModelPart model, PoseStack stack, MultiBufferSource source, float red, float green, float blue, int light, int overlay) {
        VertexConsumer consumer = source.getBuffer(StandaloneModelRenderer.getSheet(StandaloneModelRenderer.getRenderType(model)));
        for (Direction direction : DIRECTIONS) {
            StandaloneModelRenderer.putQuads(stack.last(), consumer, red, green, blue, model.getQuads(direction), light, overlay);
        }
        StandaloneModelRenderer.putQuads(stack.last(), consumer, red, green, blue, model.getQuads(null), light, overlay);
    }

    public static void submitDraw(SubmitNodeCollector collector, BlockModelPart model, PoseStack stack, float red, float green, float blue, int light, int overlay) {
        collector.submitCustomGeometry(stack, StandaloneModelRenderer.getSheet(StandaloneModelRenderer.getRenderType(model)), (pose, consumer) -> {
            for (Direction direction : DIRECTIONS) {
                StandaloneModelRenderer.putQuads(pose, consumer, red, green, blue, model.getQuads(direction), light, overlay);
            }
            StandaloneModelRenderer.putQuads(pose, consumer, red, green, blue, model.getQuads(null), light, overlay);
        });
    }

    public static void draw(QuadCollection collection, ChunkSectionLayer layer, PoseStack stack, MultiBufferSource source, float red, float green, float blue, int light, int overlay) {
        VertexConsumer consumer = source.getBuffer(StandaloneModelRenderer.getSheet(layer));
        for (Direction direction : DIRECTIONS) {
            StandaloneModelRenderer.putQuads(stack.last(), consumer, red, green, blue, collection.getQuads(direction), light, overlay);
        }
        StandaloneModelRenderer.putQuads(stack.last(), consumer, red, green, blue, collection.getQuads(null), light, overlay);
    }

    private static void putQuads(PoseStack.Pose pose, VertexConsumer consumer, float red, float green, float blue, List<BakedQuad> quads, int light, int overlay) {
        for (BakedQuad quad : quads) {
            if (quad.isTinted()) {
                red = Mth.clamp((float)red, (float)0.0f, (float)1.0f);
                green = Mth.clamp((float)green, (float)0.0f, (float)1.0f);
                blue = Mth.clamp((float)blue, (float)0.0f, (float)1.0f);
                consumer.putBulkData(pose, quad, red, green, blue, 1.0f, light, overlay);
                return;
            }
            consumer.putBulkData(pose, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }

    private static ChunkSectionLayer getRenderType(BlockModelPart part) {
        return ClientServices.CLIENT.getChunkSectionLayer(part);
    }

    private static RenderType getSheet(ChunkSectionLayer layer) {
        return layer == ChunkSectionLayer.TRANSLUCENT ? Sheets.translucentItemSheet() : Sheets.cutoutBlockSheet();
    }
}

