/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.EasyVillagersMod;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class TraderTileentityBase
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected Block workstation = Blocks.AIR;
    protected long nextRestock;

    public TraderTileentityBase(BlockEntityType<?> type, BlockState defaultState, BlockPos pos, BlockState state) {
        super(type, defaultState, pos, state);
    }

    public Block getWorkstation() {
        return this.workstation;
    }

    public boolean hasWorkstation() {
        return this.workstation != Blocks.AIR;
    }

    public void setWorkstation(Block workstation) {
        this.workstation = workstation;
        if (this.hasVillager()) {
            this.fixProfession();
        }
        this.setChanged();
        this.sync();
    }

    public Block removeWorkstation() {
        Block w = this.workstation;
        this.setWorkstation(Blocks.AIR);
        return w;
    }

    public boolean isValidBlock(Block block) {
        return PoiTypes.forState((BlockState)block.defaultBlockState()).isPresent();
    }

    public Holder<VillagerProfession> getWorkstationProfession() {
        Optional poiTypeHolder = PoiTypes.forState((BlockState)this.workstation.defaultBlockState());
        if (poiTypeHolder.isEmpty()) {
            return (Holder)BuiltInRegistries.VILLAGER_PROFESSION.get(VillagerProfession.NONE).orElseThrow();
        }
        Holder poiType = (Holder)poiTypeHolder.get();
        for (VillagerProfession profession : BuiltInRegistries.VILLAGER_PROFESSION) {
            if (!profession.heldJobSite().test(poiType)) continue;
            return BuiltInRegistries.VILLAGER_PROFESSION.wrapAsHolder((Object)profession);
        }
        return (Holder)BuiltInRegistries.VILLAGER_PROFESSION.get(VillagerProfession.NONE).orElseThrow();
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        if (this.hasWorkstation()) {
            this.fixProfession();
        }
    }

    private void fixProfession() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v == null || v.getVillagerXp() > 0 || v.getVillagerData().profession().is(VillagerProfession.NITWIT)) {
            return;
        }
        v.setVillagerData(v.getVillagerData().withProfession(this.getWorkstationProfession()));
    }

    public boolean openTradingGUI(Player playerEntity) {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return false;
        }
        if (villagerEntity.isBaby()) {
            return false;
        }
        Holder profession = villagerEntity.getVillagerData().profession();
        if (profession.is(VillagerProfession.NONE) || profession.is(VillagerProfession.NITWIT)) {
            return false;
        }
        if (villagerEntity.isTrading()) {
            return false;
        }
        if (this.level == null || this.level.isClientSide()) {
            return true;
        }
        villagerEntity.setPos((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.0, (double)this.getBlockPos().getZ() + 0.5);
        villagerEntity.startTrading(playerEntity);
        return true;
    }

    @Override
    public void tickServer() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v == null) {
            return;
        }
        if (this.advanceAge()) {
            this.sync();
        }
        this.setChanged();
        VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
        if (!v.isTrading()) {
            if (v.increaseProfessionLevelOnUpdate) {
                v.increaseMerchantCareer();
                v.increaseProfessionLevelOnUpdate = false;
                this.sync();
            }
            if (this.level.getGameTime() - this.getLastRestock() > this.nextRestock && v.getVillagerData().profession().is(this.getWorkstationProfession())) {
                this.restock();
                this.nextRestock = this.calculateNextRestock();
            }
        }
    }

    protected long calculateNextRestock() {
        return (Integer)EasyVillagersMod.SERVER_CONFIG.traderMinRestockTime.get() + this.level.random.nextInt(Math.max((Integer)EasyVillagersMod.SERVER_CONFIG.traderMaxRestockTime.get() - (Integer)EasyVillagersMod.SERVER_CONFIG.traderMinRestockTime.get(), 1));
    }

    protected void restock() {
        try {
            EasyVillagerEntity villagerEntity = this.getVillagerEntity();
            if (villagerEntity == null) {
                return;
            }
            villagerEntity.restock();
            SoundEvent workSound = ((VillagerProfession)villagerEntity.getVillagerData().profession().value()).workSound();
            if (workSound != null) {
                VillagerBlockBase.playVillagerSound(this.level, this.getBlockPos(), workSound);
            }
        }
        catch (Exception e) {
            EasyVillagersMod.LOGGER.error("Error restocking villager", (Throwable)e);
        }
    }

    protected long getLastRestock() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return 0L;
        }
        return villagerEntity.lastRestockGameTime;
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        if (this.hasWorkstation()) {
            valueOutput.putString("Workstation", BuiltInRegistries.BLOCK.getKey((Object)this.workstation).toString());
        }
        valueOutput.putLong("NextRestock", this.nextRestock);
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        Optional<Block> optionalWorkstation = valueInput.read("Workstation", ResourceLocation.CODEC).map(r -> BuiltInRegistries.BLOCK.get(r).map(Holder.Reference::value).orElse(Blocks.AIR));
        if (optionalWorkstation.isPresent()) {
            this.workstation = optionalWorkstation.get();
        } else {
            this.removeWorkstation();
        }
        this.nextRestock = valueInput.getLongOr("NextRestock", 0L);
        super.loadAdditional(valueInput);
    }
}

