/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.store.WaystonesPlayerStore;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class PersistentWaystonesPlayerStore
implements WaystonesPlayerStore {
    private static final String TAG_NAME = "WaystonesData";
    private static final String ACTIVATED_WAYSTONES = "Waystones";
    private static final String SORTING_INDEX = "SortingIndex";
    private static final String COOLDOWNS = "Cooldowns";

    @Override
    public void activateWaystone(Player player, Waystone waystone) {
        ListTag activatedWaystonesData = PersistentWaystonesPlayerStore.getActivatedWaystonesData(PersistentWaystonesPlayerStore.getWaystonesData(player));
        activatedWaystonesData.add((Object)StringTag.valueOf((String)waystone.getWaystoneUid().toString()));
    }

    @Override
    public boolean isWaystoneActivated(Player player, Waystone waystone) {
        ListTag activatedWaystones = PersistentWaystonesPlayerStore.getActivatedWaystonesData(PersistentWaystonesPlayerStore.getWaystonesData(player));
        String waystoneUid = waystone.getWaystoneUid().toString();
        for (Tag activatedWaystone : activatedWaystones) {
            if (!activatedWaystone.asString().map(waystoneUid::equals).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public List<Waystone> getWaystones(Player player) {
        ListTag activatedWaystonesTag = PersistentWaystonesPlayerStore.getActivatedWaystonesData(PersistentWaystonesPlayerStore.getWaystonesData(player));
        ArrayList<Waystone> waystones = new ArrayList<Waystone>();
        Iterator iterator = activatedWaystonesTag.iterator();
        while (iterator.hasNext()) {
            Tag activatedWaystoneTag = (Tag)iterator.next();
            activatedWaystoneTag.asString().map(UUID::fromString).ifPresentOrElse(waystoneId -> {
                WaystoneProxy proxy = new WaystoneProxy(player.level().getServer(), (UUID)waystoneId);
                if (proxy.isValid()) {
                    waystones.add(proxy);
                } else {
                    iterator.remove();
                }
            }, iterator::remove);
        }
        return waystones;
    }

    @Override
    public List<UUID> getSortingIndex(Player player) {
        ListTag sortingIndex = PersistentWaystonesPlayerStore.getSortingIndexData(PersistentWaystonesPlayerStore.getWaystonesData(player));
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (Tag entry : sortingIndex) {
            entry.asString().map(UUID::fromString).ifPresent(result::add);
        }
        return result;
    }

    @Override
    public void setSortingIndex(Player player, List<UUID> sortingIndex) {
        ListTag sortingIndexData = PersistentWaystonesPlayerStore.getSortingIndexData(PersistentWaystonesPlayerStore.getWaystonesData(player));
        sortingIndexData.clear();
        for (UUID waystoneUid : sortingIndex) {
            sortingIndexData.add((Object)StringTag.valueOf((String)waystoneUid.toString()));
        }
    }

    @Override
    public List<UUID> ensureSortingIndex(Player player, Collection<Waystone> waystones) {
        ListTag sortingIndexData = PersistentWaystonesPlayerStore.getSortingIndexData(PersistentWaystonesPlayerStore.getWaystonesData(player));
        ArrayList<UUID> sortingIndex = new ArrayList<UUID>();
        HashSet existing = new HashSet();
        for (Tag sortingIndexEntry : sortingIndexData) {
            sortingIndexEntry.asString().map(UUID::fromString).ifPresent(waystoneUid -> {
                if (existing.add(waystoneUid)) {
                    sortingIndex.add((UUID)waystoneUid);
                }
            });
        }
        for (Waystone waystone : waystones) {
            UUID waystoneUid2 = waystone.getWaystoneUid();
            if (existing.contains(waystoneUid2)) continue;
            sortingIndex.add(waystoneUid2);
            sortingIndexData.add((Object)StringTag.valueOf((String)waystoneUid2.toString()));
        }
        return sortingIndex;
    }

    @Override
    public void sortWaystoneAsFirst(Player player, UUID waystoneUid) {
        ListTag sortingIndex = PersistentWaystonesPlayerStore.getSortingIndexData(PersistentWaystonesPlayerStore.getWaystonesData(player));
        for (int i = 0; i < sortingIndex.size(); ++i) {
            Tag sortingIndexEntry = sortingIndex.get(i);
            if (!sortingIndexEntry.asString().map(it -> waystoneUid.toString().equals(it)).orElse(false).booleanValue()) continue;
            sortingIndex.remove(i);
            sortingIndex.add(0, sortingIndexEntry);
            break;
        }
    }

    @Override
    public void sortWaystoneAsLast(Player player, UUID waystoneUid) {
        ListTag sortingIndex = PersistentWaystonesPlayerStore.getSortingIndexData(PersistentWaystonesPlayerStore.getWaystonesData(player));
        for (int i = 0; i < sortingIndex.size(); ++i) {
            Tag sortingIndexEntry = sortingIndex.get(i);
            if (!sortingIndexEntry.asString().map(it -> waystoneUid.toString().equals(it)).orElse(false).booleanValue()) continue;
            sortingIndex.remove(i);
            sortingIndex.add((Object)sortingIndexEntry);
            break;
        }
    }

    @Override
    public void sortWaystoneSwap(Player player, UUID waystoneUid, UUID otherWaystoneUid) {
        ListTag sortingIndex = PersistentWaystonesPlayerStore.getSortingIndexData(PersistentWaystonesPlayerStore.getWaystonesData(player));
        int waystoneIndex = -1;
        int otherWaystoneIndex = -1;
        for (int i = 0; i < sortingIndex.size(); ++i) {
            Tag sortingIndexEntry = sortingIndex.get(i);
            if (sortingIndexEntry.asString().map(it -> waystoneUid.toString().equals(it)).orElse(false).booleanValue()) {
                waystoneIndex = i;
                continue;
            }
            if (!sortingIndexEntry.asString().map(it -> otherWaystoneUid.toString().equals(it)).orElse(false).booleanValue()) continue;
            otherWaystoneIndex = i;
        }
        if (waystoneIndex != -1 && otherWaystoneIndex != -1) {
            Collections.swap(sortingIndex, waystoneIndex, otherWaystoneIndex);
        }
    }

    @Override
    public void deactivateWaystone(Player player, Waystone waystone) {
        CompoundTag data = PersistentWaystonesPlayerStore.getWaystonesData(player);
        ListTag activatedWaystones = PersistentWaystonesPlayerStore.getActivatedWaystonesData(data);
        String waystoneUid = waystone.getWaystoneUid().toString();
        for (int i = activatedWaystones.size() - 1; i >= 0; --i) {
            Tag activatedWaystone = activatedWaystones.get(i);
            if (!activatedWaystone.asString().map(waystoneUid::equals).orElse(false).booleanValue()) continue;
            activatedWaystones.remove(i);
            break;
        }
    }

    @Override
    public Map<ResourceLocation, Long> getCooldowns(Player player) {
        CompoundTag waystonesData = PersistentWaystonesPlayerStore.getWaystonesData(player);
        HashMap<ResourceLocation, Long> cooldownMap = new HashMap<ResourceLocation, Long>();
        waystonesData.getCompound(COOLDOWNS).ifPresent(cooldowns -> {
            for (String key : cooldowns.keySet()) {
                cooldownMap.put(ResourceLocation.parse((String)key), cooldowns.getLongOr(key, 0L));
            }
        });
        return cooldownMap;
    }

    @Override
    public void resetCooldowns(Player player) {
        CompoundTag waystonesData = PersistentWaystonesPlayerStore.getWaystonesData(player);
        waystonesData.put(COOLDOWNS, (Tag)new CompoundTag());
    }

    @Override
    public long getCooldownUntil(Player player, ResourceLocation key) {
        CompoundTag waystonesData = PersistentWaystonesPlayerStore.getWaystonesData(player);
        return waystonesData.getCompound(COOLDOWNS).flatMap(it -> it.getLong(key.toString())).orElse(0L);
    }

    @Override
    public void setCooldownUntil(Player player, ResourceLocation key, long timeStamp) {
        CompoundTag waystonesData = PersistentWaystonesPlayerStore.getWaystonesData(player);
        CompoundTag cooldowns = waystonesData.getCompoundOrEmpty(COOLDOWNS);
        cooldowns.putLong(key.toString(), timeStamp);
        waystonesData.put(COOLDOWNS, (Tag)cooldowns);
    }

    private static ListTag getActivatedWaystonesData(CompoundTag data) {
        ListTag list = data.getListOrEmpty(ACTIVATED_WAYSTONES);
        data.put(ACTIVATED_WAYSTONES, (Tag)list);
        return list;
    }

    private static ListTag getSortingIndexData(CompoundTag data) {
        ListTag list = data.getList(SORTING_INDEX).orElseGet(() -> PersistentWaystonesPlayerStore.createSortingIndexFromLegacy(data));
        data.put(SORTING_INDEX, (Tag)list);
        return list;
    }

    private static CompoundTag getWaystonesData(Player player) {
        CompoundTag persistedData = Balm.getHooks().getPersistentData(player);
        CompoundTag compound = persistedData.getCompoundOrEmpty(TAG_NAME);
        persistedData.put(TAG_NAME, (Tag)compound);
        return compound;
    }

    private static ListTag createSortingIndexFromLegacy(CompoundTag data) {
        ListTag activatedWaystones = PersistentWaystonesPlayerStore.getActivatedWaystonesData(data);
        if (activatedWaystones.isEmpty()) {
            return new ListTag();
        }
        ListTag sortingIndex = new ListTag();
        sortingIndex.addAll((Collection)activatedWaystones);
        return sortingIndex;
    }
}

