/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.ArrayList;
import java.util.Collections;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.trait.IResetUseOnDamage;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.item.ScrollItemBase;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WarpScrollItem
extends ScrollItemBase
implements IResetUseOnDamage {
    public WarpScrollItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return WaystonesConfig.getActive().general.scrollUseTime;
    }

    public ItemStack finishUsingItem(final ItemStack itemStack, Level world, LivingEntity entity) {
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            final ArrayList<Waystone> waystones = new ArrayList<Waystone>(PlayerWaystoneManager.getTargetsForItem((Player)player, itemStack));
            PlayerWaystoneManager.ensureSortingIndex((Player)player, waystones);
            Balm.getNetworking().openMenu((Player)((ServerPlayer)entity), (MenuProvider)new BalmMenuProvider<ModMenus.ItemInitiatedWaystoneMenuData>(){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.waystones.waystone_selection");
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
                    return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)ModMenus.warpScrollSelection.get()), null, windowId, waystones, Collections.emptySet()).withWarpItem(itemStack).setPostTeleportHandler(context -> itemStack.consume(1, (LivingEntity)inventory.player));
                }

                public ModMenus.ItemInitiatedWaystoneMenuData getScreenOpeningData(ServerPlayer serverPlayer) {
                    return new ModMenus.ItemInitiatedWaystoneMenuData(waystones, itemStack);
                }

                public StreamCodec<RegistryFriendlyByteBuf, ModMenus.ItemInitiatedWaystoneMenuData> getScreenStreamCodec() {
                    return ModMenus.ItemInitiatedWaystoneMenuData.STREAM_CODEC;
                }
            });
        }
        return itemStack;
    }
}

