/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.item.AttunedShardItem;
import net.blay09.mods.waystones.item.BlankScrollItem;
import net.blay09.mods.waystones.item.BoundScrollItem;
import net.blay09.mods.waystones.item.CrumblingAttunedShardItem;
import net.blay09.mods.waystones.item.ReturnScrollItem;
import net.blay09.mods.waystones.item.ShardItem;
import net.blay09.mods.waystones.item.WarpScrollItem;
import net.blay09.mods.waystones.item.WarpStoneItem;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModItems {
    public static DeferredObject<CreativeModeTab> creativeModeTab;
    public static Item returnScroll;
    public static Item blankScroll;
    public static Item boundScroll;
    public static Item warpScroll;
    public static Item warpStone;
    public static Item dormantShard;
    public static Item attunedShard;
    public static Item deepslateShard;
    public static Item crumblingAttunedShard;

    public static void initialize(BalmItems items) {
        items.registerItem(identifier -> {
            returnScroll = new ReturnScrollItem(ModItems.defaultProperties(identifier));
            return returnScroll;
        }, ModItems.id("return_scroll"));
        items.registerItem(identifier -> {
            blankScroll = new BlankScrollItem(ModItems.defaultProperties(identifier));
            return blankScroll;
        }, ModItems.id("blank_scroll"));
        items.registerItem(identifier -> {
            boundScroll = new BoundScrollItem(ModItems.defaultProperties(identifier));
            return boundScroll;
        }, ModItems.id("bound_scroll"), null);
        items.registerItem(identifier -> {
            warpScroll = new WarpScrollItem(ModItems.defaultProperties(identifier));
            return warpScroll;
        }, ModItems.id("warp_scroll"));
        items.registerItem(identifier -> {
            warpStone = new WarpStoneItem(ModItems.defaultProperties(identifier));
            return warpStone;
        }, ModItems.id("warp_stone"));
        items.registerItem(identifier -> {
            dormantShard = new ShardItem(ModItems.defaultProperties(identifier));
            return dormantShard;
        }, ModItems.id("dormant_shard"));
        items.registerItem(identifier -> {
            attunedShard = new AttunedShardItem(ModItems.defaultProperties(identifier));
            return attunedShard;
        }, ModItems.id("attuned_shard"), null);
        items.registerItem(identifier -> {
            deepslateShard = new ShardItem(ModItems.defaultProperties(identifier));
            return deepslateShard;
        }, ModItems.id("deepslate_shard"), null);
        items.registerItem(identifier -> {
            crumblingAttunedShard = new CrumblingAttunedShardItem(ModItems.defaultProperties(identifier));
            return crumblingAttunedShard;
        }, ModItems.id("crumbling_attuned_shard"), null);
        creativeModeTab = items.registerCreativeModeTab(() -> new ItemStack((ItemLike)ModBlocks.waystone), ModItems.id("waystones"));
        items.setCreativeModeTabSorting(ModItems.id("waystones"), (Comparator)new Comparator<ItemLike>(){
            private static final String[] patternStrings = new String[]{"waystone", "white_portstone", "red_sharestone", "warp_plate", "blank_scroll", "return_scroll", "warp_scroll", "warp_stone", "dormant_shard", "deepslate_shard", ".+_waystone", ".+_sharestone", ".+_portstone", "attuned_shard", "crumbling_attuned_shard"};
            private static final Map<String, Integer> indexMap = new HashMap<String, Integer>();
            private static final Map<Pattern, Integer> patternIndexMap = new HashMap<Pattern, Integer>();

            private static int getIndex(String name) {
                Integer index = indexMap.get(name);
                if (index != null) {
                    return index;
                }
                for (Map.Entry<Pattern, Integer> entry : patternIndexMap.entrySet()) {
                    if (!entry.getKey().matcher(name).matches()) continue;
                    return entry.getValue();
                }
                return -1;
            }

            @Override
            public int compare(ItemLike o1, ItemLike o2) {
                ResourceLocation id1 = BuiltInRegistries.ITEM.getKey((Object)o1.asItem());
                ResourceLocation id2 = BuiltInRegistries.ITEM.getKey((Object)o2.asItem());
                String name1 = id1.getPath();
                String name2 = id2.getPath();
                int index1 = 1.getIndex(name1);
                int index2 = 1.getIndex(name2);
                if (index1 != -1 && index2 != -1) {
                    return Integer.compare(index1, index2);
                }
                if (index1 != -1) {
                    return -1;
                }
                if (index2 != -1) {
                    return 1;
                }
                return name1.compareTo(name2);
            }

            static {
                for (int i = 0; i < patternStrings.length; ++i) {
                    String patternString = patternStrings[i];
                    indexMap.put(patternString, i);
                    patternIndexMap.put(Pattern.compile(patternString), i);
                }
            }
        });
    }

    private static Item.Properties defaultProperties(ResourceLocation identifier) {
        return new Item.Properties().setId(ModItems.itemId(identifier));
    }

    private static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"waystones", (String)name);
    }

    private static ResourceKey<Item> itemId(ResourceLocation identifier) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)identifier);
    }
}

