/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.network.message.ClientboundKnownWaystonesPacket;
import net.blay09.mods.waystones.network.message.ClientboundPlayerWaystoneCooldownsPacket;
import net.blay09.mods.waystones.network.message.ClientboundSortingIndexPacket;
import net.blay09.mods.waystones.network.message.ClientboundUpdateWaystonePacket;
import net.blay09.mods.waystones.network.message.ClientboundWaystoneRemovedPacket;
import net.blay09.mods.waystones.store.SavedDataWaystonesStore;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class WaystoneSyncManager {
    public static void sendWaystoneUpdateToAll(@Nullable MinecraftServer server, Waystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.getPlayerList().getPlayers();
        for (ServerPlayer player : players) {
            WaystoneSyncManager.sendWaystoneUpdate((Player)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((Player)player);
        }
    }

    public static void sendWaystoneRemovalToAll(@Nullable MinecraftServer server, Waystone waystone, boolean wasDestroyed) {
        if (server == null) {
            return;
        }
        List players = server.getPlayerList().getPlayers();
        for (ServerPlayer player : players) {
            WaystoneSyncManager.sendWaystoneRemoval((Player)player, waystone, wasDestroyed);
        }
    }

    public static void sendSortingIndex(Player player) {
        List<UUID> sortingIndex = PlayerWaystoneManager.getSortingIndex(player);
        Balm.getNetworking().sendTo(player, (CustomPacketPayload)new ClientboundSortingIndexPacket(sortingIndex));
    }

    public static void sendActivatedWaystones(Player player) {
        ArrayList<Waystone> waystones = new ArrayList<Waystone>(PlayerWaystoneManager.getActivatedWaystones(player));
        Balm.getNetworking().sendTo(player, (CustomPacketPayload)new ClientboundKnownWaystonesPacket(WaystoneTypes.WAYSTONE, waystones));
    }

    public static void sendWaystonesOfType(ResourceLocation waystoneType, ServerPlayer player) {
        ArrayList<Waystone> warpPlates = new ArrayList<Waystone>(SavedDataWaystonesStore.get(player.level().getServer()).getWaystonesByType(waystoneType));
        Balm.getNetworking().sendTo((Player)player, (CustomPacketPayload)new ClientboundKnownWaystonesPacket(waystoneType, warpPlates));
    }

    public static void sendWaystoneUpdate(Player player, Waystone waystone) {
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
            Balm.getNetworking().sendTo(player, (CustomPacketPayload)new ClientboundUpdateWaystonePacket(waystone));
        }
    }

    public static void sendWaystoneRemoval(Player player, Waystone waystone, boolean wasDestroyed) {
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
            Balm.getNetworking().sendTo(player, (CustomPacketPayload)new ClientboundWaystoneRemovedPacket(waystone.getWaystoneType(), waystone.getWaystoneUid(), wasDestroyed));
        }
    }

    public static void sendWaystoneCooldowns(Player player) {
        Map<ResourceLocation, Long> cooldowns = PlayerWaystoneManager.getCooldowns(player);
        Balm.getNetworking().sendTo(player, (CustomPacketPayload)new ClientboundPlayerWaystoneCooldownsPacket(cooldowns));
    }
}

