/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.blay09.mods.waystones.api.WaystoneStyle;
import net.blay09.mods.waystones.api.WaystoneStyles;
import net.blay09.mods.waystones.block.PortstoneBlock;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.blay09.mods.waystones.client.ModRenderers;
import net.blay09.mods.waystones.client.render.SharestoneModel;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class WaystoneRenderer
implements BlockEntityRenderer<WaystoneBlockEntity, WaystoneRenderState> {
    private static final Material MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace((String)"waystone_overlays/waystone_active"));
    private final MaterialSet materials;
    private final SharestoneModel model;

    public WaystoneRenderer(BlockEntityRendererProvider.Context context) {
        this.materials = context.materials();
        this.model = new SharestoneModel(context.bakeLayer(ModRenderers.waystoneModel));
    }

    public WaystoneRenderState createRenderState() {
        return new WaystoneRenderState();
    }

    public void extractRenderState(WaystoneBlockEntity blockEntity, WaystoneRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        if (renderState.blockState.getValue((Property)SharestoneBlock.HALF) != DoubleBlockHalf.LOWER) {
            renderState.skip = true;
            return;
        }
        renderState.facing = (Direction)renderState.blockState.getValue((Property)PortstoneBlock.FACING);
        renderState.glow = !WaystonesConfig.getActive().client.disableTextGlow;
        WaystoneStyle style = WaystoneStyles.getStyle(renderState.blockState.getBlock());
        renderState.runeColor = style != null ? style.getRuneColor() : -1;
        LocalPlayer player = Minecraft.getInstance().player;
        renderState.showRunes = PlayerWaystoneManager.isWaystoneActivated((Player)Objects.requireNonNull(player), blockEntity.getWaystone());
    }

    public void submit(WaystoneRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.skip) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.facing.toYRot()));
        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(180.0f));
        poseStack.scale(0.5f, 0.5f, 0.5f);
        if (renderState.showRunes) {
            poseStack.scale(1.05f, 1.05f, 1.05f);
            TextureAtlasSprite sprite = this.materials.get(MATERIAL);
            submitNodeCollector.submitModel((Model)this.model, (Object)Unit.INSTANCE, poseStack, MATERIAL.renderType(RenderType::entityCutout), renderState.glow ? 0xF000F0 : renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.runeColor, sprite, 0, renderState.breakProgress);
        }
        poseStack.popPose();
    }

    public static class WaystoneRenderState
    extends BlockEntityRenderState {
        public boolean skip;
        public Direction facing = Direction.NORTH;
        public boolean glow;
        public boolean showRunes;
        public int runeColor;
    }
}

