/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.entity.SharestoneBlockEntity;
import net.blay09.mods.waystones.client.ModRenderers;
import net.blay09.mods.waystones.client.render.SharestoneModel;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class SharestoneRenderer
implements BlockEntityRenderer<SharestoneBlockEntity, SharestoneRenderState> {
    private static final Material MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace((String)"waystone_overlays/sharestone_color"));
    private static ItemStack warpStoneItem;
    private final MaterialSet materials;
    private final ItemModelResolver itemModelResolver;
    private final SharestoneModel model;

    public SharestoneRenderer(BlockEntityRendererProvider.Context context) {
        this.materials = context.materials();
        this.itemModelResolver = context.itemModelResolver();
        this.model = new SharestoneModel(context.bakeLayer(ModRenderers.sharestoneModel));
    }

    public SharestoneRenderState createRenderState() {
        return new SharestoneRenderState();
    }

    public void extractRenderState(SharestoneBlockEntity blockEntity, SharestoneRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        if (renderState.blockState.getValue((Property)SharestoneBlock.HALF) != DoubleBlockHalf.LOWER) {
            renderState.skip = true;
            return;
        }
        Level level = blockEntity.getLevel();
        long gameTime = level != null ? level.getGameTime() : 0L;
        renderState.glow = !WaystonesConfig.getActive().client.disableTextGlow;
        renderState.runeColor = ((SharestoneBlock)blockEntity.getBlockState().getBlock()).getColor().getTextureDiffuseColor();
        if (warpStoneItem == null) {
            warpStoneItem = new ItemStack((ItemLike)ModItems.warpStone);
            level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.UNBREAKING).ifPresent(it -> warpStoneItem.enchant((Holder)it, 1));
        }
        this.itemModelResolver.updateForTopItem(renderState.item, warpStoneItem, ItemDisplayContext.FIXED, level, null, (int)renderState.blockPos.asLong());
        renderState.itemYaw = (float)gameTime / 2.0f % 360.0f;
        renderState.itemOffsetY = (float)Math.sin((float)gameTime / 8.0f) * 0.025f;
    }

    public void submit(SharestoneRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.skip) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(180.0f));
        poseStack.translate(0.0f, -2.0f, 0.0f);
        float scale = 1.01f;
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.scale(scale, scale, scale);
        TextureAtlasSprite sprite = this.materials.get(MATERIAL);
        submitNodeCollector.submitModel((Model)this.model, (Object)Unit.INSTANCE, poseStack, MATERIAL.renderType(RenderType::entityCutout), renderState.glow ? 0xF000F0 : renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.runeColor, sprite, 0, renderState.breakProgress);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.0f + renderState.itemOffsetY, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(renderState.itemYaw));
        poseStack.scale(0.5f, 0.5f, 0.5f);
        renderState.item.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }

    public static class SharestoneRenderState
    extends BlockEntityRenderState {
        public boolean skip;
        public boolean glow;
        public int runeColor;
        public final ItemStackRenderState item = new ItemStackRenderState();
        public float itemYaw;
        public float itemOffsetY;
    }
}

