/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_beautiful_torches.core.registry;

import common.com.cursee.more_beautiful_torches.Constants;
import common.com.cursee.more_beautiful_torches.MoreBeautifulTorches;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModBlocks {
    public static final LinkedList<Block> REGISTERED = new LinkedList();

    public static void register(BiConsumer<Block, ResourceLocation> consumer) {
        ArrayList<String> lines = new ArrayList<String>();
        try (InputStream input = MoreBeautifulTorches.class.getResourceAsStream("/blocks.txt");){
            if (input == null) {
                throw new IOException("Failed to create InputStream from /blocks.txt");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                String line2;
                while ((line2 = reader.readLine()) != null) {
                    lines.add(line2);
                }
            }
        }
        catch (IOException e) {
            Constants.LOG.info("Failed to load a resource: {}", (Object)e.getMessage());
        }
        lines.forEach(line -> {
            String torch = line + "_torch";
            ResourceKey key1 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(torch));
            TorchBlock block1 = new TorchBlock(ParticleTypes.FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).setId(key1));
            consumer.accept((Block)block1, MoreBeautifulTorches.identifier(torch));
            String wallTorch = line + "_wall_torch";
            ResourceKey key2 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(wallTorch));
            WallTorchBlock block2 = new WallTorchBlock(ParticleTypes.FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).overrideLootTable(block1.getLootTable()).overrideDescription(block1.getDescriptionId()).setId(key2));
            consumer.accept((Block)block2, MoreBeautifulTorches.identifier(wallTorch));
            String redstoneTorch = line + "_redstone_torch";
            ResourceKey key3 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(redstoneTorch));
            RedstoneTorchBlock block3 = new RedstoneTorchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_TORCH).setId(key3));
            consumer.accept((Block)block3, MoreBeautifulTorches.identifier(redstoneTorch));
            String redstoneWallTorch = line + "_redstone_wall_torch";
            ResourceKey key4 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(redstoneWallTorch));
            RedstoneWallTorchBlock block4 = new RedstoneWallTorchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_WALL_TORCH).overrideLootTable(block3.getLootTable()).overrideDescription(block3.getDescriptionId()).setId(key4));
            consumer.accept((Block)block4, MoreBeautifulTorches.identifier(redstoneWallTorch));
            String soulTorch = line + "_soul_torch";
            ResourceKey key5 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(soulTorch));
            TorchBlock block5 = new TorchBlock(ParticleTypes.SOUL_FIRE_FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_TORCH).setId(key5));
            consumer.accept((Block)block5, MoreBeautifulTorches.identifier(soulTorch));
            String soulWallTorch = line + "_soul_wall_torch";
            ResourceKey key6 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(soulWallTorch));
            WallTorchBlock block6 = new WallTorchBlock(ParticleTypes.SOUL_FIRE_FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_WALL_TORCH).overrideLootTable(block5.getLootTable()).overrideDescription(block5.getDescriptionId()).setId(key6));
            consumer.accept((Block)block6, MoreBeautifulTorches.identifier(soulWallTorch));
            REGISTERED.add((Block)block1);
            REGISTERED.add((Block)block2);
            REGISTERED.add((Block)block3);
            REGISTERED.add((Block)block4);
            REGISTERED.add((Block)block5);
            REGISTERED.add((Block)block6);
        });
    }
}

