/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes.layout;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.IScrollBoxWidget;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.library.gui.OffsetJeiInputHandler;
import mezz.jei.library.gui.widgets.AbstractScrollWidget;
import mezz.jei.library.gui.widgets.ScrollBoxRecipeWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.RegistryOps;
import org.joml.Matrix3x2fStack;

public class RecipeLayoutDrawableErrored<R>
implements IRecipeLayoutDrawable<R> {
    private final IRecipeCategory<R> recipeCategory;
    private final R recipe;
    private final IScrollBoxWidget scrollBoxWidget;
    private final IJeiInputHandler inputHandler;
    private final IScalableDrawable background;
    private final int borderPadding;
    private ImmutableRect2i area;

    public RecipeLayoutDrawableErrored(IRecipeCategory<R> recipeCategory, R recipe, IScalableDrawable background, int borderPadding) {
        this.recipeCategory = recipeCategory;
        this.recipe = recipe;
        this.area = new ImmutableRect2i(0, 0, Math.max(100, recipeCategory.getWidth()), recipeCategory.getHeight());
        this.background = background;
        this.borderPadding = borderPadding;
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>();
        lines.add((FormattedText)Component.translatable((String)"gui.jei.category.recipe.crashed").withStyle(ChatFormatting.RED));
        lines.add((FormattedText)Component.empty());
        lines.add((FormattedText)Component.literal((String)recipeCategory.getRecipeType().getUid().toString()).withStyle(ChatFormatting.GRAY));
        IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
        IJeiHelpers jeiHelpers = jeiRuntime.getJeiHelpers();
        ICodecHelper codecHelper = jeiHelpers.getCodecHelper();
        IRecipeManager recipeManager = jeiRuntime.getRecipeManager();
        Codec<R> codec = recipeCategory.getCodec(codecHelper, recipeManager);
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        assert (level != null);
        RegistryAccess registryAccess = level.registryAccess();
        RegistryOps registryOps = registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        DataResult dataResult = codec.encodeStart((DynamicOps)registryOps, recipe);
        Optional result = dataResult.result();
        if (result.isPresent()) {
            String encoded = ((JsonElement)result.get()).toString();
            lines.add((FormattedText)Component.empty());
            lines.add((FormattedText)Component.literal((String)encoded).withStyle(ChatFormatting.GRAY));
        }
        this.scrollBoxWidget = new ScrollBoxRecipeWidget(this.area.width() + AbstractScrollWidget.getScrollBoxScrollbarExtraWidth(), this.area.height(), 0, 0).setContents(lines);
        this.inputHandler = new OffsetJeiInputHandler(this.scrollBoxWidget, this::getScreenPosition);
    }

    private ScreenPosition getScreenPosition() {
        return this.area.getScreenPosition();
    }

    @Override
    public void setPosition(int posX, int posY) {
        this.area = this.area.setPosition(posX, posY);
    }

    @Override
    public void drawRecipe(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.background.draw(guiGraphics, this.getRectWithBorder());
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        poseStack.translate((float)this.area.x(), (float)this.area.y());
        int recipeMouseX = mouseX - this.area.x();
        int recipeMouseY = mouseY - this.area.y();
        ScreenPosition position = this.scrollBoxWidget.getPosition();
        poseStack.pushMatrix();
        poseStack.translate((float)position.x(), (float)position.y());
        this.scrollBoxWidget.drawWidget(guiGraphics, recipeMouseX - position.x(), recipeMouseY - position.y());
        poseStack.popMatrix();
    }

    @Override
    public void drawOverlays(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(int mouseX, int mouseY, IIngredientType<T> ingredientType) {
        return Optional.empty();
    }

    @Override
    @Deprecated
    public Optional<IRecipeSlotDrawable> getRecipeSlotUnderMouse(double mouseX, double mouseY) {
        return Optional.empty();
    }

    @Override
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
        return Optional.empty();
    }

    @Override
    public Rect2i getRect() {
        return this.area.toMutable();
    }

    @Override
    public Rect2i getRectWithBorder() {
        return this.area.expandBy(this.borderPadding).toMutable();
    }

    @Override
    public Rect2i getRecipeTransferButtonArea() {
        return new Rect2i(0, 0, 0, 0);
    }

    @Override
    public Rect2i getRecipeBookmarkButtonArea() {
        return new Rect2i(0, 0, 0, 0);
    }

    @Override
    public IRecipeSlotsView getRecipeSlotsView() {
        return List::of;
    }

    @Override
    public IRecipeCategory<R> getRecipeCategory() {
        return this.recipeCategory;
    }

    @Override
    public R getRecipe() {
        return this.recipe;
    }

    @Override
    public IJeiInputHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public void tick() {
    }
}

