/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.logic;

import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.content.logic.transform.Stage;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

@SerialClass
public class CookingData {
    @SerialClass.SerialField
    private long lastActionTime;
    @SerialClass.SerialField
    private float speed = 1.0f;
    @SerialClass.SerialField
    public int glowstone;
    @SerialClass.SerialField
    public int redstone;
    @SerialClass.SerialField
    public ArrayList<CookingEntry> contents = new ArrayList();

    public void update(long time) {
        this.lastActionTime = time;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void stir(long time, int reduce) {
        this.update(time);
        for (CookingEntry entry : this.contents) {
            entry.stir(time, reduce);
        }
    }

    public void addItem(ItemStack item, long time) {
        if (item.m_150930_(Items.f_42525_)) {
            ++this.glowstone;
        }
        if (item.m_150930_(Items.f_42451_)) {
            ++this.redstone;
        }
        this.update(time);
        this.contents.add(new CookingEntry(item, time));
    }

    @SerialClass
    public static class CookingEntry {
        @SerialClass.SerialField
        private ItemStack item;
        @SerialClass.SerialField
        private long startTime;
        @SerialClass.SerialField
        private long lastStirTime;
        @SerialClass.SerialField
        private int maxStirTime;

        @Deprecated
        public CookingEntry() {
        }

        public CookingEntry(ItemStack item, long time) {
            this.item = item;
            this.startTime = time;
            this.lastStirTime = time;
            this.maxStirTime = 0;
        }

        public void stir(long time, int reduce) {
            this.maxStirTime = Math.max(this.maxStirTime, (int)(time - this.lastStirTime));
            this.lastStirTime = time + (long)reduce;
        }

        public float getDuration(CookingData data, float partialTick) {
            return (partialTick + (float)data.lastActionTime - (float)this.startTime) * data.speed;
        }

        public float timeSinceStir(CookingData data, float partialTick) {
            return Math.max(0.0f, partialTick + (float)data.lastActionTime - (float)this.lastStirTime) * data.speed;
        }

        public float getMaxStirTime(CookingData data) {
            return (float)this.maxStirTime * data.speed;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public long seed() {
            return new Random(this.startTime).nextLong();
        }

        public Stage getStage(CookingData data) {
            IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(this.getItem());
            assert (config != null);
            float time = this.getDuration(data, 0.0f);
            if (time < (float)config.min_time) {
                return Stage.RAW;
            }
            if (time < (float)config.max_time) {
                return Stage.COOKED;
            }
            return Stage.OVERCOOKED;
        }
    }
}

