/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.ancient_obelisks.structure;

import com.robertx22.ancient_obelisks.capability.ObeliskEntityCapability;
import com.robertx22.ancient_obelisks.configs.ObeliskConfig;
import com.robertx22.ancient_obelisks.database.holders.ObeliskRelicStats;
import com.robertx22.ancient_obelisks.item.ObeliskItemMapData;
import com.robertx22.ancient_obelisks.main.ObeliskWords;
import com.robertx22.ancient_obelisks.main.ObelisksMain;
import com.robertx22.library_of_exile.components.LibMapCap;
import com.robertx22.library_of_exile.components.LibMapData;
import com.robertx22.library_of_exile.database.affix.base.ExileAffixData;
import com.robertx22.library_of_exile.database.mob_list.MobEntry;
import com.robertx22.library_of_exile.database.mob_list.MobList;
import com.robertx22.library_of_exile.database.relic.stat.RelicStat;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ObeliskMapData {
    public ObeliskItemMapData item = new ObeliskItemMapData();
    public int currentWave = -1;
    public int mobsLeftForWave = 0;
    public int mob_kills = 0;
    public int endsIn = 30;
    public int waveCd = 0;
    public int x = 0;
    public int z = 0;
    public boolean canSpawnRewards = false;
    public boolean spawnedRewards = false;

    public float getTotalRewardChance() {
        float chance = (float)this.mob_kills * ((Double)ObeliskConfig.get().LOOT_CHANCE_PER_MOB_KILL.get()).floatValue();
        return chance *= this.item.getLootMulti();
    }

    public List<LivingEntity> getAllLivingMobs(Level world, BlockPos pos) {
        return world.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)pos.m_252807_(), (double)35.0, (double)30.0, (double)35.0)).stream().filter(x -> ObeliskEntityCapability.get((LivingEntity)x).data.isObeSpawn).collect(Collectors.toList());
    }

    public void tryStartNewWave(Level world, BlockPos pos) {
        if (this.waveCd > 0 && ((Boolean)ObeliskConfig.get().SKIP_COOLDOWN_IF_NO_MORE_MOBS.get()).booleanValue() && this.mobsLeftForWave < 1 && this.getAllLivingMobs(world, pos).isEmpty()) {
            this.waveCd = 0;
        }
        if (this.waveCd-- > 0) {
            return;
        }
        this.waveCd = (Integer)ObeliskConfig.get().WAVE_COOLDOWN_SECONDS.get();
        ++this.currentWave;
        this.mobsLeftForWave = (Integer)ObeliskConfig.get().TOTAL_MOBS_PER_WAVE.get();
        LibMapData data = LibMapCap.getData((Level)world, (BlockPos)pos);
        if (data != null) {
            float multi = 1.0f + data.relicStats.get((RelicStat)ObeliskRelicStats.INSTANCE.TOTAL_WAVE_MOBS.get()) / 100.0f;
            this.mobsLeftForWave = (int)((float)this.mobsLeftForWave * multi);
        }
        for (Player p : ObelisksMain.OBELISK_MAP_STRUCTURE.getAllPlayersInMap(world, pos)) {
            if (this.currentWave == this.item.maxWaves - 1) {
                p.m_213846_((Component)ObeliskWords.LAST_WAVE.get(this.currentWave).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            } else {
                p.m_213846_((Component)ObeliskWords.WAVE_X_STARTING.get(this.currentWave + 1).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            }
            for (ExileAffixData affix : this.item.getAffixesForWave(this.currentWave)) {
                p.m_213846_((Component)ObeliskWords.NEW_WAVE_AFFIX.get(affix.getAffix().getPrefixedName(affix.perc)).m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
        }
    }

    public void waveLogicSecond(Level world, BlockPos pos) {
        if (this.currentWave >= this.item.maxWaves - 1) {
            if (this.endsIn-- < 1) {
                this.canSpawnRewards = true;
            }
            return;
        }
        if (this.mobsLeftForWave < 1) {
            this.tryStartNewWave(world, pos);
        }
        if (this.mobsLeftForWave > 0) {
            float spawnChance = (float)((Integer)ObeliskConfig.get().MOB_SPAWN_CHANCE.get()).intValue() * this.item.getSpawnRateMulti();
            LibMapData data = LibMapCap.getData((Level)world, (BlockPos)pos);
            if (data != null) {
                float multi = 1.0f + data.relicStats.get((RelicStat)ObeliskRelicStats.INSTANCE.MOB_SPAWN_CHANCE.get()) / 100.0f;
                spawnChance *= multi;
            }
            if (RandomUtils.roll((float)spawnChance)) {
                int toSpawn = (Integer)ObeliskConfig.get().MOB_SPAWNS_PER_SECOND.get();
                if (toSpawn > this.mobsLeftForWave) {
                    toSpawn = this.mobsLeftForWave;
                }
                MobList mobs = (MobList)ObelisksMain.MOB_SPAWNS.getPredeterminedRandom(world, pos);
                List<Direction> dirs = Arrays.asList(Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH);
                for (int i = 0; i < toSpawn; ++i) {
                    MobEntry mob = (MobEntry)RandomUtils.weightedRandom((Collection)mobs.mobs);
                    this.spawnMob(world, pos.m_121955_(((Direction)RandomUtils.randomFromList(dirs)).m_122436_().m_142393_(2)), mob.getType());
                }
            }
        }
    }

    public void spawnMob(Level world, BlockPos pos, EntityType type) {
        --this.mobsLeftForWave;
        LivingEntity en = (LivingEntity)type.m_20615_(world);
        en.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (en instanceof Mob) {
            Mob mob = (Mob)en;
            mob.m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(pos), MobSpawnType.COMMAND, (SpawnGroupData)null, (CompoundTag)null);
        }
        world.m_7967_((Entity)en);
        ObeliskEntityCapability.get((LivingEntity)en).data.isObeSpawn = true;
    }
}

