/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.ancient_obelisks.main;

import com.google.common.collect.Lists;
import com.robertx22.ancient_obelisks.capability.ObeliskEntityCapability;
import com.robertx22.ancient_obelisks.configs.ObeliskConfig;
import com.robertx22.ancient_obelisks.database.Obelisk;
import com.robertx22.ancient_obelisks.database.ObeliskDatabase;
import com.robertx22.ancient_obelisks.item.ObeliskItemNbt;
import com.robertx22.ancient_obelisks.item.ObeliskMapItem;
import com.robertx22.ancient_obelisks.main.ComponentInit;
import com.robertx22.ancient_obelisks.main.ObeliskClient;
import com.robertx22.ancient_obelisks.main.ObeliskCommands;
import com.robertx22.ancient_obelisks.main.ObeliskEntries;
import com.robertx22.ancient_obelisks.main.ObeliskLootTables;
import com.robertx22.ancient_obelisks.main.ObeliskMobTierStats;
import com.robertx22.ancient_obelisks.main.ObeliskMobValidator;
import com.robertx22.ancient_obelisks.main.ObeliskModConstructor;
import com.robertx22.ancient_obelisks.main.ObeliskRewardLogic;
import com.robertx22.ancient_obelisks.main.ObeliskWords;
import com.robertx22.ancient_obelisks.structure.ObeliskMapCapability;
import com.robertx22.ancient_obelisks.structure.ObeliskMapData;
import com.robertx22.ancient_obelisks.structure.ObeliskMapStructure;
import com.robertx22.ancient_obelisks.structure.ObeliskWorldData;
import com.robertx22.library_of_exile.config.map_dimension.MapDimensionConfigDefaults;
import com.robertx22.library_of_exile.config.map_dimension.MapRegisterBuilder;
import com.robertx22.library_of_exile.database.affix.base.ExileAffixData;
import com.robertx22.library_of_exile.database.affix.base.GrabMobAffixesEvent;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.database.init.PredeterminedResult;
import com.robertx22.library_of_exile.database.mob_list.MobList;
import com.robertx22.library_of_exile.dimension.MapChunkGenEvent;
import com.robertx22.library_of_exile.dimension.MapContentType;
import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.ApiForgeEvents;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.helpers.OrderedModConstructor;
import com.robertx22.library_of_exile.registry.register_info.ModRequiredRegisterInfo;
import com.robertx22.library_of_exile.registry.util.ExileRegistryUtil;
import com.robertx22.library_of_exile.unidentified.IdentifiableItems;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="ancient_obelisks")
public class ObelisksMain {
    public static boolean RUN_DEV_TOOLS = false;
    public static String MODID = "ancient_obelisks";
    public static String DIMENSION_ID = "ancient_obelisks:obelisk";
    public static ResourceLocation DIMENSION_KEY = new ResourceLocation(DIMENSION_ID);
    public static ModRequiredRegisterInfo REGISTER_INFO = new ModRequiredRegisterInfo(MODID);
    public static ObeliskMapStructure OBELISK_MAP_STRUCTURE = new ObeliskMapStructure();
    public static MapDimensionInfo MAP = new MapDimensionInfo(DIMENSION_KEY, (MapStructure)OBELISK_MAP_STRUCTURE, MapContentType.SIDE_CONTENT, Arrays.asList(new MapStructure[0]), new ObeliskMobValidator(), new MapDimensionConfigDefaults(3, 2)){

        public void clearMapDataOnFolderWipe(MinecraftServer minecraftServer) {
            ObeliskMapCapability.get((Level)minecraftServer.m_129783_()).data = new ObeliskWorldData();
        }
    };
    public static PredeterminedResult<MobList> MOB_SPAWNS = new PredeterminedResult<MobList>(){

        public ExileRegistryType getRegistryType() {
            return LibDatabase.MOB_LIST;
        }

        public MobList getPredeterminedRandomINTERNAL(Random random, Level level, ChunkPos pos) {
            Obelisk dungeon = OBELISK_MAP_STRUCTURE.getObelisk(pos);
            return (MobList)LibDatabase.MobLists().getFilterWrapped(x -> dungeon.mob_list_tag_check.matches((ExileRegistry)x).can).random(random.nextDouble());
        }
    };

    public static ResourceLocation id(String id) {
        return new ResourceLocation(MODID, id);
    }

    public static void debugMsg(Player p, String s) {
        if (p.m_7500_()) {
            p.m_213846_((Component)Component.m_237113_((String)("[Debug Info]:" + s)));
        }
    }

    public ObelisksMain() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        OrderedModConstructor.register((OrderedModConstructor)new ObeliskModConstructor(MODID), (IEventBus)bus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::clientSetup));
        new MapRegisterBuilder(MAP).chunkGenerator((EventConsumer)new EventConsumer<MapChunkGenEvent>(){

            public void accept(MapChunkGenEvent event) {
                if (event.mapId.equals("obelisk")) {
                    OBELISK_MAP_STRUCTURE.generateInChunk((ServerLevelAccessor)event.world, event.manager, event.chunk.m_7697_());
                }
            }
        }, ObelisksMain.id("obelisk_chunk_gen")).build();
        if (RUN_DEV_TOOLS) {
            ExileRegistryUtil.setCurrentRegistarMod((String)MODID);
            ApiForgeEvents.registerForgeEvent(PlayerEvent.PlayerLoggedInEvent.class, event -> ObeliskDatabase.generateJsons());
        }
        ApiForgeEvents.registerForgeEvent(GatherDataEvent.class, event -> {
            PackOutput output = event.getGenerator().getPackOutput();
            LootTableProvider.SubProviderEntry chestsLootTables = new LootTableProvider.SubProviderEntry(ObeliskLootTables.ObeliskLootTableProvider::new, LootContextParamSets.f_81411_);
            LootTableProvider provider = new LootTableProvider(output, Set.of(), List.of(chestsLootTables));
            event.getGenerator().addProvider(true, (DataProvider)provider);
            if (RUN_DEV_TOOLS) {
                // empty if block
            }
            try {
                event.getGenerator().m_123917_();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ObeliskConfig.SPEC);
        bus.addListener(this::commonSetupEvent);
        ExileEvents.GRAB_MOB_AFFIXES.register((EventConsumer)new EventConsumer<GrabMobAffixesEvent>(){

            public void accept(GrabMobAffixesEvent e) {
                ObeliskMapData mapdata;
                MapDimensionInfo map = MapDimensions.getInfo((Level)e.en.m_9236_());
                if (map != null && map.dimensionId.equals((Object)DIMENSION_KEY) && (mapdata = (ObeliskMapData)ObeliskMapCapability.get((Level)e.en.m_9236_()).data.data.getData((MapStructure)OBELISK_MAP_STRUCTURE, e.en.m_20183_())) != null) {
                    for (int i = 0; i < mapdata.currentWave + 1; ++i) {
                        for (ExileAffixData affix : mapdata.item.getAffixesForWave(i)) {
                            if (!affix.getAffix().affects.is(e.en)) continue;
                            e.allAffixes.add(affix);
                        }
                    }
                }
            }
        });
        ApiForgeEvents.registerForgeEvent(MobSpawnEvent.class, event -> {
            Mob en = event.getEntity();
            if (!en.m_9236_().f_46443_) {
                ObelisksMain.ifMapData(event.getEntity().m_9236_(), event.getEntity().m_20183_()).ifPresent(x -> ObeliskMobTierStats.tryApply((LivingEntity)en, x));
            }
        });
        ObeliskEntries.CREATIVE_TAB.register(MODID, () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 2).m_257737_(() -> ((BlockItem)ObeliskEntries.OBELISK_ITEM.get()).m_7968_()).m_257941_((Component)ObeliskWords.CREATIVE_TAB.get(new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD})).m_257501_(new CreativeModeTab.DisplayItemsGenerator(){

            public void m_257865_(CreativeModeTab.ItemDisplayParameters param, CreativeModeTab.Output output) {
                for (Item item : ForgeRegistries.ITEMS) {
                    if (!ForgeRegistries.ITEMS.getKey((Object)item).m_135827_().equals(MODID)) continue;
                    output.m_246326_((ItemLike)item);
                }
            }
        }).m_257652_());
        ObeliskCommands.init();
        ObeliskRewardLogic.init();
        ExileEvents.ON_CHEST_LOOTED.register((EventConsumer)new EventConsumer<ExileEvents.OnChestLooted>(){

            public void accept(ExileEvents.OnChestLooted e) {
                try {
                    List<Integer> empty;
                    float chance = (float)((Double)ObeliskConfig.get().OBELISK_SPAWN_CHANCE_ON_CHEST_LOOT.get() * (double)ObeliskConfig.get().getDimChanceMulti(e.player.m_9236_()));
                    if (RandomUtils.roll((float)chance) && !MapDimensions.isMap((Level)e.player.m_9236_()) && !(empty = ObelisksMain.mygetEmptySlotsRandomized(e.inventory, new Random())).isEmpty()) {
                        int index = (Integer)RandomUtils.randomFromList(empty);
                        ItemStack map = ObeliskMapItem.blankMap(((ObeliskMapItem)((Object)ObeliskEntries.OBELISK_MAP_ITEM.get())).m_7968_(), false);
                        e.inventory.m_6836_(index, map);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        IdentifiableItems.register((ResourceLocation)ObeliskEntries.OBELISK_MAP_ITEM.getId(), (IdentifiableItems.Config)new IdentifiableItems.Config(){

            public boolean isUnidentified(ItemStack stack) {
                return !ObeliskItemNbt.OBELISK_MAP.has(stack);
            }

            public void identify(Player player, ItemStack stack) {
                ObeliskMapItem.blankMap(stack, false);
            }
        });
        System.out.println("Ancient Obelisks loaded.");
    }

    private static List<Integer> mygetEmptySlotsRandomized(Container inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public static Optional<ObeliskMapData> ifMapData(Level level, BlockPos pos) {
        ObeliskMapData mapdata;
        if (level.f_46443_) {
            return Optional.empty();
        }
        MapDimensionInfo map = MapDimensions.getInfo((Level)level);
        if (map != null && map.dimensionId.equals((Object)DIMENSION_KEY) && (mapdata = (ObeliskMapData)ObeliskMapCapability.get((Level)level).data.data.getData((MapStructure)OBELISK_MAP_STRUCTURE, pos)) != null) {
            return Optional.of(mapdata);
        }
        return Optional.empty();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ObeliskClient.init();
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        ComponentInit.reg();
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, x -> x.addCapability(ObeliskMapCapability.RESOURCE, (ICapabilityProvider)new ObeliskMapCapability((Level)x.getObject())));
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, x -> {
            Object patt12733$temp = x.getObject();
            if (patt12733$temp instanceof LivingEntity) {
                LivingEntity en = (LivingEntity)patt12733$temp;
                x.addCapability(ObeliskEntityCapability.RESOURCE, (ICapabilityProvider)new ObeliskEntityCapability(en));
            }
        });
    }
}

