/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.ancient_obelisks.main;

import com.robertx22.ancient_obelisks.configs.ObeliskConfig;
import com.robertx22.ancient_obelisks.database.holders.ObeliskRelicStats;
import com.robertx22.ancient_obelisks.main.ObeliskEntries;
import com.robertx22.ancient_obelisks.main.ObeliskLootTables;
import com.robertx22.ancient_obelisks.main.ObeliskWords;
import com.robertx22.ancient_obelisks.main.ObelisksMain;
import com.robertx22.ancient_obelisks.structure.ObeliskMapData;
import com.robertx22.library_of_exile.components.LibMapCap;
import com.robertx22.library_of_exile.components.LibMapData;
import com.robertx22.library_of_exile.main.ApiForgeEvents;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class ObeliskRewardLogic {
    public static int whileRoll(float chance) {
        int amount = 0;
        while (chance > 0.0f) {
            float currentChance = chance;
            float maxChance = 100.0f;
            if (currentChance > maxChance) {
                currentChance = maxChance;
            }
            chance -= currentChance;
            if (!RandomUtils.roll((float)currentChance)) continue;
            ++amount;
        }
        return amount;
    }

    public static void spawnChests(ObeliskMapData d, Level world, BlockPos pos) {
        LibMapData data;
        for (Player p : ObelisksMain.OBELISK_MAP_STRUCTURE.getAllPlayersInMap(world, pos)) {
            p.m_213846_((Component)ObeliskWords.OBELISK_END.get(new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE));
        }
        int chests = ObeliskRewardLogic.whileRoll(d.getTotalRewardChance());
        if (chests > (Integer)ObeliskConfig.get().MAX_CHEST_REWARDS.get()) {
            chests = (Integer)ObeliskConfig.get().MAX_CHEST_REWARDS.get();
        }
        if (chests < 1) {
            chests = 1;
        }
        if ((data = LibMapCap.getData((Level)world, (BlockPos)pos)) != null && RandomUtils.roll((float)data.relicStats.get(ObeliskRelicStats.INSTANCE.TRIPLE_CHEST_REWARD_CHANCE))) {
            chests *= 3;
        }
        for (int i = 0; i < chests; ++i) {
            BlockPos cpos = ObeliskRewardLogic.findNearbyFreeChestPos(world, pos);
            if (cpos == null) continue;
            ObeliskRewardLogic.spawnChest(world, cpos, ObeliskLootTables.LOOT);
        }
    }

    public static void spawnChest(Level world, BlockPos pos, ResourceLocation loottable) {
        world.m_7731_(pos, Blocks.f_50087_.m_49966_(), 3);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity ce = (RandomizableContainerBlockEntity)blockEntity;
            ce.m_59626_(loottable, world.f_46441_.m_188505_());
        }
    }

    public static BlockPos findNearbyFreeChestPos(Level world, BlockPos pos) {
        return ObeliskRewardLogic.findNearbyFreeChestPos(world, pos, state -> !state.m_60795_() && !state.m_60713_(Blocks.f_50087_) && !state.m_60713_((Block)ObeliskEntries.OBELISK_REWARD_BLOCK.get()), 1);
    }

    public static BlockPos findNearbyFreeChestPos(Level world, BlockPos pos, Predicate<BlockState> groundCheck, int freeBlocks) {
        BlockPos nearest = null;
        int rad = 5;
        for (int x = -rad; x < rad; ++x) {
            for (int y = -2; y < 2; ++y) {
                for (int z = -rad; z < rad; ++z) {
                    BlockPos check = pos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(check);
                    if (!groundCheck.test(state)) continue;
                    ArrayList<BlockPos> airChecks = new ArrayList<BlockPos>();
                    for (int i = 0; i < freeBlocks; ++i) {
                        airChecks.add(check.m_7494_());
                    }
                    if (!airChecks.stream().allMatch(e -> world.m_8055_(e).m_60795_()) || nearest != null && !(nearest.m_123331_((Vec3i)pos) > check.m_7494_().m_123331_((Vec3i)pos))) continue;
                    nearest = check.m_7494_();
                }
            }
        }
        return nearest;
    }

    public static void init() {
        ApiForgeEvents.registerForgeEvent(LivingDeathEvent.class, x -> {
            LivingEntity en = x.getEntity();
            Level world = en.m_9236_();
            if (!world.f_46443_) {
                ObelisksMain.ifMapData(world, en.m_20183_()).ifPresent(d -> ++d.mob_kills);
            }
        });
    }
}

