/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.ancient_obelisks.main;

import com.robertx22.ancient_obelisks.configs.ObeliskConfig;
import com.robertx22.ancient_obelisks.structure.ObeliskMapData;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ObeliskMobTierStats {
    public static UUID DMG = UUID.fromString("012d5bd9-4917-4747-b188-1f8da6871133");
    public static UUID HP = UUID.fromString("19719d5f-e800-468b-839c-b907f9ab89ab");

    public static AttributeModifier hpMod(int tier) {
        float hp = ((Double)ObeliskConfig.get().MOB_HP_PER_TIER.get()).floatValue() * (float)tier;
        AttributeModifier mod = new AttributeModifier(HP, Attributes.f_22276_.m_22087_(), (double)hp, AttributeModifier.Operation.MULTIPLY_TOTAL);
        return mod;
    }

    public static AttributeModifier dmgMod(int tier) {
        float dmg = ((Double)ObeliskConfig.get().MOB_DMG_PER_TIER.get()).floatValue() * (float)tier;
        AttributeModifier mod = new AttributeModifier(DMG, Attributes.f_22281_.m_22087_(), (double)dmg, AttributeModifier.Operation.MULTIPLY_TOTAL);
        return mod;
    }

    public static void tryApply(LivingEntity en, ObeliskMapData data) {
        try {
            int tier = data.item.tier;
            if (tier > 0) {
                AttributeMap attributes = en.m_21204_();
                AttributeInstance maxHealthAttribute = en.m_21051_(Attributes.f_22276_);
                if (!attributes.m_22154_(Attributes.f_22276_, HP) && maxHealthAttribute != null) {
                    maxHealthAttribute.m_22125_(ObeliskMobTierStats.hpMod(tier));
                    en.m_21153_((float)((int)maxHealthAttribute.m_22135_()));
                }
                AttributeInstance attackDamageAttribute = en.m_21051_(Attributes.f_22281_);
                if (!attributes.m_22154_(Attributes.f_22281_, DMG) && attackDamageAttribute != null) {
                    attackDamageAttribute.m_22125_(ObeliskMobTierStats.dmgMod(tier));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

