/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.ancient_obelisks.item;

import com.robertx22.ancient_obelisks.configs.ObeliskConfig;
import com.robertx22.ancient_obelisks.item.ObeliskItemNbt;
import com.robertx22.ancient_obelisks.main.ObeliskMobTierStats;
import com.robertx22.ancient_obelisks.main.ObeliskWords;
import com.robertx22.ancient_obelisks.structure.ObeliskMapCapability;
import com.robertx22.library_of_exile.database.affix.base.ExileAffixData;
import com.robertx22.library_of_exile.database.affix.types.AttributeMobAffix;
import com.robertx22.library_of_exile.database.affix.types.ExileMobAffix;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ObeliskItemMapData {
    public HashMap<Integer, List<ExileAffixData>> affixes = new HashMap();
    public int tier = 0;
    public int spawn_rate = 0;
    public int x = 0;
    public int z = 0;
    public int maxWaves = 0;
    public boolean relic = false;

    public List<Component> getTierTooltip() {
        ArrayList<Component> all = new ArrayList<Component>();
        if (this.tier > 0) {
            all.add((Component)ObeliskWords.OBELISK_TIER_X.get(this.tier).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD}));
            all.add((Component)AttributeMobAffix.getTooltip((Attribute)Attributes.f_22276_, (AttributeModifier)ObeliskMobTierStats.hpMod(this.tier)));
            all.add((Component)AttributeMobAffix.getTooltip((Attribute)Attributes.f_22281_, (AttributeModifier)ObeliskMobTierStats.dmgMod(this.tier)));
        }
        return all;
    }

    public float getLootMulti() {
        float chance = 1.0f;
        chance *= 1.0f + (float)this.tier * ((Double)ObeliskConfig.get().LOOT_MULTI_PER_TIER.get()).floatValue();
        chance *= 1.0f + (float)this.totalAffixes() * ((Double)ObeliskConfig.get().LOOT_MULTI_PER_AFFIX.get()).floatValue();
        return chance *= 1.0f + (float)this.spawn_rate / 100.0f;
    }

    public float getSpawnRateMulti() {
        float chance = 1.0f;
        return chance *= 1.0f + (float)this.spawn_rate / 100.0f;
    }

    public List<Component> getLootBonusTooltip() {
        ArrayList<Component> all = new ArrayList<Component>();
        int loot = (int)(this.getLootMulti() * 100.0f);
        all.add((Component)ObeliskWords.MAP_LOOT_BONUS.get(loot).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        return all;
    }

    public List<Component> spawnRateTooltip() {
        ArrayList<Component> all = new ArrayList<Component>();
        int loot = (int)(this.getSpawnRateMulti() * 100.0f);
        all.add((Component)ObeliskWords.SPAWN_RATE.get(loot).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        return all;
    }

    public int totalAffixes() {
        int i = 0;
        for (Map.Entry<Integer, List<ExileAffixData>> en : this.affixes.entrySet()) {
            i += en.getValue().size();
        }
        return i;
    }

    public List<Component> getAffixesTooltip() {
        ArrayList<Component> all = new ArrayList<Component>();
        for (int i = 0; i < this.maxWaves; ++i) {
            all.add((Component)ObeliskWords.ITEM_WAVE_X.get(i + 1).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            for (ExileAffixData data : this.getAffixesForWave(i)) {
                MutableComponent text = data.getAffix().getPrefixedName(data.perc);
                all.add((Component)text);
            }
        }
        return all;
    }

    public List<ExileAffixData> getAffixesForWave(int wave) {
        return this.affixes.getOrDefault(wave, new ArrayList());
    }

    public void generateInitialWaves() {
        for (int i = 0; i < 3; ++i) {
            ++this.maxWaves;
            this.addRandomAffix();
        }
    }

    public ChunkPos getOrSetStartPos(Level world, ItemStack stack) {
        if (this.x == 0 && this.z == 0) {
            ChunkPos start = ObeliskMapCapability.get((Level)world).data.counter.getNextAndIncrement();
            this.x = start.f_45578_;
            this.z = start.f_45579_;
        }
        ObeliskItemNbt.OBELISK_MAP.saveTo(stack, (Object)this);
        return new ChunkPos(this.x, this.z);
    }

    public int getWaveWithLeastAffixes() {
        int least = 100;
        int index = -1;
        for (int i = 0; i < this.maxWaves; ++i) {
            int amountCheck = ((List)this.affixes.getOrDefault(i, new ArrayList())).size();
            if (amountCheck >= least) continue;
            least = amountCheck;
            index = i;
        }
        return index;
    }

    public void addRandomAffix() {
        ArrayList<String> allCurrent = new ArrayList<String>();
        for (List<ExileAffixData> value : this.affixes.values()) {
            for (ExileAffixData d : value) {
                allCurrent.add(d.affix);
            }
        }
        ExileMobAffix affix = (ExileMobAffix)LibDatabase.MobAffixes().getFilterWrapped(x -> !allCurrent.contains(x.GUID())).random();
        ExileAffixData data = new ExileAffixData(affix.id, RandomUtils.RandomRange((int)0, (int)100));
        int wave = this.getWaveWithLeastAffixes();
        if (wave > -1) {
            this.addAffixToWave(wave, data);
        }
    }

    public void addAffixToWave(int wave, ExileAffixData data) {
        if (!this.affixes.containsKey(wave)) {
            this.affixes.put(wave, new ArrayList());
        }
        this.affixes.get(wave).add(data);
    }
}

