/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.ancient_obelisks.database.item_reqs;

import com.robertx22.ancient_obelisks.database.item_reqs.ObeliskReq;
import com.robertx22.ancient_obelisks.item.ObeliskItemMapData;
import com.robertx22.ancient_obelisks.main.ObelisksMain;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class LessThanXWavesReq
extends ObeliskReq {
    public Data data;

    public LessThanXWavesReq(String id, Data data) {
        super("less_than_x_waves", id);
        this.data = data;
    }

    @Override
    public boolean isValid(ItemStack gear, ObeliskItemMapData data) {
        return this.data.waves > data.maxWaves;
    }

    public MutableComponent getDescWithParams() {
        return this.getTranslation(TranslationType.DESCRIPTION).getTranslatedName(new Object[]{this.data.waves});
    }

    public TranslationBuilder createTranslationBuilder() {
        String plural = Math.abs(this.data.waves) > 1 ? "s" : "";
        return TranslationBuilder.of((String)ObelisksMain.MODID).desc(ExileTranslation.registry((ExileRegistry)this, (String)("Must have less than %1$s Wave" + plural)));
    }

    public Class<?> getClassForSerialization() {
        return LessThanXWavesReq.class;
    }

    public record Data(int waves) {
    }
}

