/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.ancient_obelisks.database.item_reqs;

import com.robertx22.ancient_obelisks.configs.ObeliskConfig;
import com.robertx22.ancient_obelisks.database.item_reqs.ObeliskReq;
import com.robertx22.ancient_obelisks.item.ObeliskItemMapData;
import com.robertx22.ancient_obelisks.main.ObelisksMain;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class IsLessThanMaxTier
extends ObeliskReq {
    public IsLessThanMaxTier(String id) {
        super("is_less_than_max_tier", id);
    }

    @Override
    public boolean isValid(ItemStack gear, ObeliskItemMapData data) {
        return (Integer)ObeliskConfig.get().MAX_OBELISK_TIER.get() > data.tier;
    }

    public MutableComponent getDescWithParams() {
        return this.getTranslation(TranslationType.DESCRIPTION).getTranslatedName(new Object[]{ObeliskConfig.get().MAX_OBELISK_TIER.get()});
    }

    public TranslationBuilder createTranslationBuilder() {
        return TranslationBuilder.of((String)ObelisksMain.MODID).desc(ExileTranslation.registry((ExileRegistry)this, (String)"Obelisk Tier must be lower than %1$s"));
    }

    public Class<?> getClassForSerialization() {
        return IsLessThanMaxTier.class;
    }
}

