/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.ancient_obelisks.database.item_mods;

import com.robertx22.ancient_obelisks.database.item_mods.ObeliskMapMod;
import com.robertx22.ancient_obelisks.item.ObeliskItemMapData;
import com.robertx22.ancient_obelisks.main.ObelisksMain;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModification;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModificationResult;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class AddObeliskWaveMod
extends ObeliskMapMod {
    public Data data;

    public AddObeliskWaveMod(String id, Data data) {
        super("add_obelisk_wave", id);
        this.data = data;
    }

    @Override
    public void modifyGear(ItemStack stack, ObeliskItemMapData data, ItemModificationResult r) {
        for (int i = 0; i < this.data.waves(); ++i) {
            ++data.maxWaves;
            data.addRandomAffix();
        }
    }

    public ItemModification.OutcomeType getOutcomeType() {
        return ItemModification.OutcomeType.GOOD;
    }

    public MutableComponent getDescWithParams() {
        return this.getTranslation(TranslationType.DESCRIPTION).getTranslatedName(new Object[]{this.data.waves});
    }

    public TranslationBuilder createTranslationBuilder() {
        String addword = this.data.waves > 0 ? "Add" : "Remove";
        String plural = Math.abs(this.data.waves) > 1 ? "s" : "";
        return TranslationBuilder.of((String)ObelisksMain.MODID).desc(ExileTranslation.registry((ExileRegistry)this, (String)(addword + " %1$s Wave" + plural)));
    }

    public Class<?> getClassForSerialization() {
        return AddObeliskWaveMod.class;
    }

    public record Data(int waves) {
    }
}

