/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.ancient_obelisks.configs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ObeliskConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ObeliskConfig CONFIG;
    public ForgeConfigSpec.IntValue MAX_OBELISK_TIER;
    public ForgeConfigSpec.IntValue MAX_CHEST_REWARDS;
    public ForgeConfigSpec.DoubleValue MOB_HP_PER_TIER;
    public ForgeConfigSpec.DoubleValue MOB_DMG_PER_TIER;
    public ForgeConfigSpec.DoubleValue LOOT_MULTI_PER_TIER;
    public ForgeConfigSpec.DoubleValue LOOT_MULTI_PER_AFFIX;
    public ForgeConfigSpec.DoubleValue LOOT_CHANCE_PER_MOB_KILL;
    public ForgeConfigSpec.DoubleValue OBELISK_SPAWN_CHANCE_ON_CHEST_LOOT;
    public ForgeConfigSpec.BooleanValue SKIP_COOLDOWN_IF_NO_MORE_MOBS;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_CHANCE_MULTI;
    public ForgeConfigSpec.IntValue WAVE_COOLDOWN_SECONDS;
    public ForgeConfigSpec.IntValue MOB_SPAWNS_PER_SECOND;
    public ForgeConfigSpec.IntValue MOB_SPAWN_CHANCE;
    public ForgeConfigSpec.IntValue TOTAL_MOBS_PER_WAVE;
    public HashMap<String, Float> dimChanceMap = new HashMap();

    public static ObeliskConfig get() {
        return CONFIG;
    }

    public HashMap<String, Float> getDimChanceMap() {
        if (this.dimChanceMap.isEmpty()) {
            for (String s : (List)this.DIMENSION_CHANCE_MULTI.get()) {
                String dim = s.split("-")[0];
                Float multi = Float.valueOf(Float.parseFloat(s.split("-")[1]));
                this.dimChanceMap.put(dim, multi);
            }
        }
        return this.dimChanceMap;
    }

    public float getDimChanceMulti(Level level) {
        String dimid = level.m_220362_().m_135782_().toString();
        HashMap<String, Float> map = this.getDimChanceMap();
        return map.getOrDefault(dimid, Float.valueOf(1.0f)).floatValue();
    }

    ObeliskConfig(ForgeConfigSpec.Builder b) {
        b.comment("Ancient Obelisk Configs").push("general");
        this.DIMENSION_CHANCE_MULTI = b.comment("Obelisk spawn chance multi per dimension").defineList("DIMENSION_CHANCE_MULTI", () -> Arrays.asList("mmorpg:dungeon-0"), x -> true);
        this.WAVE_COOLDOWN_SECONDS = b.comment("When new wave starts, this cooldown has to pass before a new wave can start").defineInRange("WAVE_COOLDOWN_SECONDS", 60, 1, 1000);
        this.MOB_SPAWNS_PER_SECOND = b.defineInRange("MOB_SPAWNS_PER_SECOND", 1, 1, 50);
        this.MOB_SPAWN_CHANCE = b.comment("You can use low mob spawn chance with high mob spawns config to more randomly spawn mobs, or keep chance high and spawn count low to spawn them consistently over time.\nDo note, there's usually around 4 spawners in the arena").defineInRange("MOB_SPAWN_CHANCE", 10, 1, 100);
        this.TOTAL_MOBS_PER_WAVE = b.comment("Each wave will have this many mobs. When the mobs are done spawning, the new wave will start, unless wave cooldown is there.").defineInRange("TOTAL_MOBS_PER_WAVE", 15, 1, 100);
        this.MAX_OBELISK_TIER = b.comment("Each obelisk tier increases the Mob Stats and rewards").defineInRange("MAX_OBELISK_TIER", 10, 1, 1000);
        this.MAX_CHEST_REWARDS = b.comment("Maximum amount of chests that can spawn at end of obelisk fight\nUseful as a safety net in case you set your loot multipliers too high so you don't spawn.. 1000 chests accidentally").defineInRange("MAX_CHEST_REWARDS", 10, 1, 1000);
        this.MOB_HP_PER_TIER = b.comment("Mob hp multiplier per obelisk tier").defineInRange("MOB_HP_PER_TIER", (double)0.2f, 0.0, 1000.0);
        this.MOB_DMG_PER_TIER = b.comment("Mob attack damage multiplier per obelisk tier").defineInRange("MOB_DMG_PER_TIER", (double)0.05f, 0.0, 1000.0);
        this.LOOT_MULTI_PER_TIER = b.comment("Loot Multi x tier for obelisk end of fight reward").defineInRange("LOOT_MULTI_PER_TIER", (double)0.05f, 0.0, 1.0);
        this.LOOT_MULTI_PER_AFFIX = b.comment("Loot Multi x tier for obelisk end of fight reward").defineInRange("LOOT_MULTI_PER_AFFIX", (double)0.1f, 0.0, 1.0);
        this.LOOT_CHANCE_PER_MOB_KILL = b.comment("Every mob you kill inside the obelisk will add x chance to spawn loot chests at the end.\nIf the total is say 50, it means 50% chance to spawn a chest. If it's 150, then it's 1 chest + 50% chance for another.\nMake sure this value isn't too big because this chance is multiplied by tier and affix counts").defineInRange("LOOT_CHANCE_PER_MOB_KILL", 2.0, 0.0, 100.0);
        this.OBELISK_SPAWN_CHANCE_ON_CHEST_LOOT = b.comment("When you loot new chests with loot tables, obelisk maps have a chance to spawn as extra loot").defineInRange("OBELISK_SPAWN_CHANCE_ON_CHEST_LOOT", 5.0, 0.0, 100.0);
        this.SKIP_COOLDOWN_IF_NO_MORE_MOBS = b.comment("Starts new wave right away if all mobs are dead").define("SKIP_COOLDOWN_IF_NO_MORE_MOBS", true);
        b.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ObeliskConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (ObeliskConfig)specPair.getLeft();
    }
}

