/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.worldgen.configurations.tree.boblingtree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.worldgen.configurations.ModTrunkPlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class BoblingTreeTrunkPlacer
extends TrunkPlacer {
    public static final Codec<BoblingTreeTrunkPlacer> CODEC = RecordCodecBuilder.create(p_338099_ -> BoblingTreeTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)p_338099_).apply((Applicative)p_338099_, BoblingTreeTrunkPlacer::new));
    public static final BlockStateProvider BLACK_STONE = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50730_.m_49966_(), 100).m_146271_((Object)Blocks.f_50706_.m_49966_(), 60));
    public static final BlockStateProvider DEEPSLATE = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_152550_.m_49966_(), 100).m_146271_((Object)Blocks.f_152468_.m_49966_(), 80).m_146271_((Object)Blocks.f_152474_.m_49966_(), 50).m_146271_((Object)Blocks.f_50264_.m_49966_(), 50));
    public static final BlockStateProvider STONE = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50069_.m_49966_(), 100).m_146271_((Object)Blocks.f_49997_.m_49966_(), 80).m_146271_((Object)Blocks.f_49995_.m_49966_(), 50).m_146271_((Object)Blocks.f_152505_.m_49966_(), 50));

    public BoblingTreeTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)ModTrunkPlacerTypes.BOBLING_TREE_TRUNK.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader levelSimulatedReader, BiConsumer<BlockPos, BlockState> biConsumer, RandomSource randomSource, int freeHeight, BlockPos startPos, TreeConfiguration treeConfiguration) {
        ArrayList<Branch> branches = new ArrayList<Branch>();
        for (int height = 0; height < freeHeight; ++height) {
            double chance = 0.6;
            List directions = Direction.Plane.HORIZONTAL.m_235694_(randomSource);
            do {
                chance -= 0.2;
                Direction direction = (Direction)directions.get(randomSource.m_188503_(directions.size()));
                BlockPos pos = startPos.m_6630_(height);
                int h = randomSource.m_188503_(4) + 1 - height / 2;
                Branch branch = new Branch(pos, direction, 0, height);
                branches.add(branch);
            } while (randomSource.m_188500_() < chance && !directions.isEmpty());
            for (int b = 0; b < branches.size(); ++b) {
                Branch newBranch;
                Branch branch = (Branch)branches.get(b);
                BlockPos.MutableBlockPos mutableBlockPos = branch.blockPos.m_122032_();
                int h = branch.height;
                this.placeBlock(biConsumer, randomSource, (BlockPos)mutableBlockPos.m_122173_(branch.direction), startPos);
                if (randomSource.m_188500_() < 0.66) {
                    this.placeBlock(biConsumer, randomSource, (BlockPos)mutableBlockPos.m_122173_(branch.direction), startPos);
                }
                if (branch.height < height) {
                    this.placeBlock(biConsumer, randomSource, (BlockPos)mutableBlockPos.m_122173_(Direction.UP), startPos);
                    ++h;
                }
                if ((newBranch = new Branch(mutableBlockPos.m_7949_(), branch.direction, h, branch.maxHeight)).equals(branch)) continue;
                branches.set(b, branch);
            }
            this.placeBlock(biConsumer, randomSource, startPos.m_6630_(height), startPos);
        }
        return List.of();
    }

    protected void placeBlock(BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, BlockPos startPos) {
        blockSetter.accept(pos, this.determineBlockVariation(startPos, pos, random));
    }

    public BlockState determineBlockVariation(BlockPos startPos, BlockPos blockPos, RandomSource random) {
        int dist = startPos.m_123333_((Vec3i)blockPos);
        if (dist > 5 && random.m_188500_() < 0.8) {
            return BLACK_STONE.m_213972_(random, blockPos);
        }
        if (dist <= 5 && dist > 2 && random.m_188500_() < 0.8) {
            return DEEPSLATE.m_213972_(random, blockPos);
        }
        return STONE.m_213972_(random, blockPos);
    }

    protected boolean m_213554_(LevelSimulatedReader level, BlockPos pos) {
        return super.m_213554_(level, pos) || level.m_7433_(pos, blockState -> blockState.m_204336_(ModTags.ModBlockTags.VIVICUS_TREE_REPLACABLE));
    }

    public record Branch(BlockPos blockPos, Direction direction, int height, int maxHeight) {
    }
}

