/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.mixins;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpriteResourceLoader.class})
public abstract class SpriteResourceLoaderMixin {
    @Inject(method={"load"}, at={@At(value="RETURN")})
    private static void moresnifferflowers$load(ResourceManager resourceManager, ResourceLocation location, CallbackInfoReturnable<SpriteResourceLoader> cir) {
        List<String> trims = List.of("aroma", "carnage", "tater", "nether_wart", "carotene", "grain", "beat");
        if (location.m_135815_().equals("armor_trims")) {
            for (SpriteSource source : ((SpriteResourceLoaderMixin)cir.getReturnValue()).getSources()) {
                if (!(source instanceof PalettedPermutationsAccessor)) continue;
                PalettedPermutationsAccessor permutations = (PalettedPermutationsAccessor)source;
                for (String trim : trims) {
                    ResourceLocation trimLocation = MoreSnifferFlowers.loc("trims/models/armor/" + trim);
                    ResourceLocation leggingsTrimLocation = MoreSnifferFlowers.loc("trims/models/armor/" + trim + "_leggings");
                    permutations.setTextures((List<ResourceLocation>)ImmutableList.builder().addAll(permutations.getTextures()).add((Object[])new ResourceLocation[]{trimLocation, leggingsTrimLocation}).build());
                }
            }
        }
    }

    @Accessor(value="sources")
    abstract List<SpriteSource> getSources();

    @Mixin(value={PalettedPermutations.class})
    private static interface PalettedPermutationsAccessor {
        @Accessor
        public List<ResourceLocation> getTextures();

        @Accessor(value="textures")
        @Mutable
        public void setTextures(List<ResourceLocation> var1);

        @Accessor
        public ResourceLocation getPaletteKey();
    }
}

