/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import java.util.List;
import net.abraxator.moresnifferflowers.blockentities.DyespriaPlantBlockEntity;
import net.abraxator.moresnifferflowers.capability.BlockPatternCapability;
import net.abraxator.moresnifferflowers.client.ModColorHandler;
import net.abraxator.moresnifferflowers.components.BlockPattern;
import net.abraxator.moresnifferflowers.components.Colorable;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.items.DyespriaItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DyescrapiaItem
extends BlockItem {
    public DyescrapiaItem(Item.Properties properties) {
        super((Block)ModBlocks.DYESCRAPIA_PLANT.get(), properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(pos);
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        ItemStack stack = context.m_43722_();
        int uses = DyescrapiaItem.getDyescrapiaUses(stack) + 1;
        if (BlockPatternCapability.hasPattern(pos, level)) {
            if (!level.f_46443_) {
                if (uses >= 4) {
                    player.m_36356_(BlockPattern.fromId(BlockPatternCapability.getPattern(pos, level).patternId()).getItem().m_7968_());
                    uses = 0;
                }
                BlockPatternCapability.removePattern(pos, level);
                CompoundTag tag = stack.m_41784_();
                tag.m_128405_("uses", uses);
                stack.m_41751_(tag);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        Block block = state.m_60734_();
        if (block instanceof Colorable) {
            Colorable colorable = (Colorable)block;
            Dye dye = new Dye(colorable.getDyeFromBlock(state).color(), 1);
            if (!dye.color().equals((Object)DyeColor.WHITE)) {
                colorable.colorBlock(level, pos, state, new Dye(DyeColor.WHITE, 1));
                if (uses >= 4) {
                    player.m_36356_(Dye.stackFromDye(dye));
                    uses = 0;
                }
                CompoundTag tag = stack.m_41784_();
                tag.m_128405_("uses", uses);
                stack.m_41751_(tag);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        } else if (state.m_204336_(ModTags.ModBlockTags.DYED)) {
            String finalBlockId;
            ResourceLocation location = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
            String modId = location.m_135827_();
            String blockId = location.m_135815_();
            String validColorName = "white|light_gray|gray|black|brown|red|orange|yellow|lime|green|cyan|light_blue|blue|purple|magenta|pink";
            boolean colorless = false;
            if (blockId.endsWith("candle") || blockId.endsWith("shulker_box") || blockId.endsWith("terracotta") && !blockId.endsWith("glazed_terracotta")) {
                finalBlockId = blockId.replaceFirst(validColorName, "").replaceFirst("_", "");
                colorless = true;
            } else if (blockId.endsWith("stained_glass") || blockId.endsWith("stained_glass_pane")) {
                finalBlockId = blockId.replaceFirst(validColorName, "").replaceFirst("_stained_", "");
                colorless = true;
            } else {
                finalBlockId = blockId.replaceFirst(validColorName, "");
            }
            if (!(blockId.contains("white_") && !colorless || finalBlockId.equals(blockId))) {
                BlockEntity blockEntity;
                Block finalBlock = colorless ? (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(modId, finalBlockId)) : (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(modId, "white" + finalBlockId));
                BlockState finalBlockState = finalBlock.m_49966_();
                BlockEntity originalShulker = level.m_7702_(pos);
                CompoundTag shulkerData = null;
                if (originalShulker instanceof ShulkerBoxBlockEntity) {
                    ShulkerBoxBlockEntity entity = (ShulkerBoxBlockEntity)originalShulker;
                    shulkerData = entity.m_187482_();
                }
                if (finalBlock != Blocks.f_50016_) {
                    level.m_46597_(pos, DyespriaItem.copyAllBlockStateProperties(state, finalBlockState));
                }
                if (shulkerData != null && (blockEntity = level.m_7702_(pos)) instanceof ShulkerBoxBlockEntity) {
                    ShulkerBoxBlockEntity newShulkerBox = (ShulkerBoxBlockEntity)blockEntity;
                    newShulkerBox.m_59693_(shulkerData);
                }
                if (uses >= 4) {
                    String dyeName = blockId.replace(blockId.replaceFirst(validColorName, ""), "") + "_dye";
                    player.m_36356_(((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("minecraft", dyeName))).m_7968_());
                    uses = 0;
                }
                CompoundTag tag = stack.m_41784_();
                tag.m_128405_("uses", uses);
                stack.m_41751_(tag);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.FAIL;
        }
        return this.handlePlacement(pos, level, player, context.m_43724_(), context.m_43722_());
    }

    private InteractionResult handlePlacement(BlockPos blockPos, Level level, Player player, InteractionHand hand, ItemStack stack) {
        BlockPos posForDyespria = blockPos.m_7494_();
        BlockHitResult blockHitResult = new BlockHitResult(posForDyespria.m_7495_().m_252807_(), Direction.UP, posForDyespria.m_7495_(), false);
        UseOnContext useOnCtx = new UseOnContext(level, player, hand, stack, blockHitResult);
        InteractionResult result = super.m_6225_(useOnCtx);
        BlockEntity blockEntity = level.m_7702_(blockPos.m_7494_());
        if (blockEntity instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            entity.dye = Dye.getDyeFromDyespria(stack);
            entity.m_6596_();
        }
        return result;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142159_(ItemStack stack) {
        int input = DyescrapiaItem.getDyescrapiaUses(stack) - 1;
        int maxInput = 4;
        return ModColorHandler.barColorHelper(input, maxInput);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round((float)DyescrapiaItem.getDyescrapiaUses(stack) * 13.0f / 4.0f);
    }

    public static int getDyescrapiaUses(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("uses") ? tag.m_128451_("uses") : 0;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_264568_((String)"tooltip.dyescrapia", (String)"Scrapes the dye off of colored blocks").m_130940_(ChatFormatting.GOLD));
    }
}

