/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities.boat;

import java.util.function.IntFunction;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ModBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(ModBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ModBoatEntity(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
    }

    public ModBoatEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)ModEntityTypes.MOD_CORRUPTED_BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public Item m_38369_() {
        return switch (this.getModVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case Type.CORRUPTED -> (Item)ModItems.CORRUPTED_BOAT.get();
            case Type.VIVICUS -> (Item)ModItems.VIVICUS_BOAT.get();
        };
    }

    public void setVariant(Type pVariant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)pVariant.ordinal());
    }

    public Type getModVariant() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)Type.CORRUPTED.ordinal());
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128359_("Type", this.getModVariant().m_7912_());
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("Type", 8)) {
            this.setVariant(Type.byName(tag.m_128461_("Type")));
        }
    }

    public static enum Type implements StringRepresentable
    {
        CORRUPTED((Block)ModBlocks.CORRUPTED_PLANKS.get(), "corrupted"),
        VIVICUS((Block)ModBlocks.VIVICUS_PLANKS.get(), "vivicus");

        private final String name;
        private final Block planks;
        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;

        private Type(Block pPlanks, String pName) {
            this.name = pName;
            this.planks = pPlanks;
        }

        public String m_7912_() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static Type byName(String pName) {
            return (Type)CODEC.m_262792_(pName, (Enum)CORRUPTED);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
            BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

