/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import java.util.UUID;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UntouchableCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private final LazyOptional<UntouchableCapability> optional = LazyOptional.of(() -> this);
    public static final ResourceLocation ID = MoreSnifferFlowers.loc("untouchable");
    public static final UUID UUID_SPEED = UUID.fromString("41DD0153-E92A-B00B-A550-EFFEC535FEED");
    public static final UUID UUID_RESISTANCE = UUID.fromString("41DD0153-BE51-B00B-A550-EFFEC535FEED");
    public double lastX = 0.0;
    public double lastZ = 0.0;
    public int lastSpeed = 0;
    public float speedModifier = 0.0f;

    public void onAttacked() {
        this.speedModifier *= 0.7f;
    }

    public void onEffectEnd(Player player) {
        player.m_21051_(Attributes.f_22279_).m_22120_(UUID_SPEED);
        player.m_21051_(Attributes.f_22284_).m_22120_(UUID_RESISTANCE);
        this.speedModifier = 0.0f;
    }

    public void tick(Player player, int amplifier) {
        Vec3 position = player.m_20182_();
        double posX = position.f_82479_;
        double posZ = position.f_82481_;
        if (this.lastX == 0.0 && this.lastZ == 0.0 && this.lastSpeed == 0) {
            this.lastX = posX;
            this.lastZ = posZ;
            return;
        }
        float speedAccumulation = 5.0E-5f;
        float maxSpeed = 150 + amplifier * 15;
        speedAccumulation += speedAccumulation / 3.0f * (float)amplifier;
        double speedX = Math.abs(posX - this.lastX);
        double speedZ = Math.abs(posZ - this.lastZ);
        int speed = Math.round((float)(speedX * speedX + speedZ * speedZ) * 1000.0f);
        float armorModifier = Mth.m_14143_((float)(this.speedModifier * 400.0f));
        if (armorModifier < 0.0f) {
            armorModifier = 0.0f;
        }
        if (player.m_20142_()) {
            if ((float)speed <= maxSpeed) {
                this.speedModifier += speedAccumulation;
            }
        } else if (this.speedModifier > 0.0f) {
            this.speedModifier -= speedAccumulation * 15.0f;
        }
        player.m_21051_(Attributes.f_22279_).m_22120_(UUID_SPEED);
        player.m_21051_(Attributes.f_22284_).m_22120_(UUID_RESISTANCE);
        AttributeModifier mod = new AttributeModifier(UUID_SPEED, "untouchable_speed", (double)this.speedModifier, AttributeModifier.Operation.ADDITION);
        AttributeModifier mod1 = new AttributeModifier(UUID_RESISTANCE, "untouchable_resistance", (double)armorModifier, AttributeModifier.Operation.ADDITION);
        player.m_21051_(Attributes.f_22279_).m_22118_(mod);
        player.m_21051_(Attributes.f_22284_).m_22118_(mod1);
        this.lastSpeed = speed;
        this.lastX = posX;
        this.lastZ = posZ;
    }

    public void debugPrint() {
        System.out.println("Speed Modifier = " + this.speedModifier + " lastSpeed =" + this.lastSpeed);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityList.UNTOUCHABLE.orEmpty(cap, this.optional);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("lastX", this.lastX);
        tag.m_128347_("lastZ", this.lastZ);
        tag.m_128405_("speed", this.lastSpeed);
        tag.m_128350_("speedMod", this.speedModifier);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.lastX = nbt.m_128459_("lastX");
        this.lastZ = nbt.m_128459_("lastZ");
        this.lastSpeed = nbt.m_128451_("speed");
        this.speedModifier = nbt.m_128457_("speedMod");
    }
}

