/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.capability;

import java.util.Optional;
import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.capability.HardenedMouthCapability;
import net.abraxator.moresnifferflowers.client.gui.slot.HardenedMouthSlot;
import net.abraxator.moresnifferflowers.init.ModEffects;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.networking.toClient.SyncMouthSlotsPacket;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HardenedMouthCapabilityHandler
implements HardenedMouthCapability,
ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static int SLOT_COUNT = 2;
    NonNullList<ItemStack> mouthSlots = NonNullList.m_122780_((int)SLOT_COUNT, (Object)ItemStack.f_41583_);
    public int cooldown = 0;
    private final LazyOptional<HardenedMouthCapabilityHandler> optional = LazyOptional.of(() -> this);

    @Override
    public NonNullList<ItemStack> getMouthSlotItems() {
        return this.mouthSlots;
    }

    @Override
    public void setAllItems(NonNullList<ItemStack> itemStacks) {
        for (int i = 0; i < itemStacks.size(); ++i) {
            this.mouthSlots.set(i, (Object)((ItemStack)itemStacks.get(i)));
        }
    }

    @Override
    public void setItem(int index, ItemStack stack) {
        this.mouthSlots.set(index, (Object)stack);
    }

    @Override
    public ItemStack getItem(int index) {
        return (ItemStack)this.mouthSlots.get(index);
    }

    @Override
    public void clear() {
        this.mouthSlots.clear();
    }

    @Override
    public void sync(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncMouthSlotsPacket(this.mouthSlots, this.cooldown));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("cooldown", this.cooldown);
        ContainerHelper.m_18973_((CompoundTag)tag, this.mouthSlots);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.mouthSlots = NonNullList.m_122780_((int)SLOT_COUNT, (Object)ItemStack.f_41583_);
        this.cooldown = nbt.m_128451_("cooldown");
        ContainerHelper.m_18980_((CompoundTag)nbt, this.mouthSlots);
    }

    @Override
    public void onEffectEnd(Player player) {
        this.getMouthSlotItems().forEach(itemStack -> {
            if (HardenedMouthSlot.moveToPlayerInventory((AbstractContainerMenu)player.f_36095_, itemStack)) {
                return;
            }
            if (itemStack.m_41619_()) {
                return;
            }
            player.m_36176_(itemStack, true);
        });
        this.clear();
        this.sync(player);
    }

    @Override
    public void tick(Player player) {
        if (player.m_9236_().f_46443_ || !player.m_21023_((MobEffect)ModEffects.HARDENED_MOUTH.get())) {
            return;
        }
        ItemStack input = this.getItem(0);
        ItemStack output = this.getItem(1);
        if (this.getSmeltingResult(player.m_9236_(), input).isEmpty() || !this.getSmeltingResult(player.m_9236_(), input).get().m_150930_(output.m_41720_()) && !output.m_41619_()) {
            this.cooldown = this.getMaxCooldown(player);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            this.sync(player);
            return;
        }
        this.getSmeltingResult(player.m_9236_(), input).ifPresentOrElse(result -> {
            if (output.m_41619_() || ItemStack.m_150942_((ItemStack)output, (ItemStack)result) && output.m_41613_() < output.m_41741_()) {
                input.m_41774_(1);
                if (output.m_41619_()) {
                    this.setItem(1, result.m_41777_());
                } else {
                    output.m_41769_(1);
                    this.setItem(1, output);
                }
                this.setItem(0, input);
                this.cooldown = this.getMaxCooldown(player);
            }
        }, () -> {
            this.cooldown = this.getMaxCooldown(player);
        });
        this.sync(player);
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public int getMaxCooldown(Player player) {
        int amplifier = 0;
        if (player.m_21023_((MobEffect)ModEffects.HARDENED_MOUTH.get())) {
            amplifier = player.m_21124_((MobEffect)ModEffects.HARDENED_MOUTH.get()).m_19564_();
        }
        return Math.max(1, 80 - amplifier * 10);
    }

    public Optional<ItemStack> getSmeltingResult(Level level, ItemStack input) {
        return level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{input}), level).map(recipe -> recipe.m_8043_(level.m_9598_()));
    }

    public boolean isEmpty() {
        return this.getItem(0).m_41619_() && this.getItem(1).m_41619_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityList.MOUTH_SLOTS.orEmpty(cap, this.optional.cast());
    }
}

