/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.multiblock;

import net.abraxator.moresnifferflowers.entities.CorruptedProjectile;
import net.abraxator.moresnifferflowers.recipes.CorruptionRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;

public interface ICorruptableMultiblock
extends IMultiBlock {
    public Block getCuredBlock();

    public Block getCorruptedBlock();

    default public boolean allBlocksPresent(LevelReader level, BlockPos pos, BlockState state) {
        IMultiBlockEntity entity;
        BlockEntity blockEntity;
        if (level.m_5776_()) {
            return true;
        }
        BlockPos center = IMultiBlock.getCenter((BlockGetter)level, (BlockPos)pos);
        boolean ret = this.getFullBlockShape(center, state, (BlockGetter)level).stream().allMatch(blockPos -> level.m_8055_(blockPos).m_60713_(this.getCuredBlock()) || level.m_8055_(blockPos).m_60713_(this.getCorruptedBlock()));
        if (ret && (blockEntity = level.m_7702_(pos)) instanceof IMultiBlockEntity && !(entity = (IMultiBlockEntity)blockEntity).isPlaced()) {
            this.getFullBlockShape(center, state, (BlockGetter)level).forEach(blockPos -> IMultiBlockEntity.setPlaced((LevelReader)level, (BlockPos)blockPos, (boolean)true));
        }
        return ret;
    }

    default public void corruptionHelper(BlockState state, Level level, BlockPos pos, Entity entityInside) {
        if (entityInside instanceof CorruptedProjectile) {
            BlockEntity blockEntity;
            CorruptedProjectile corruptedProjectile = (CorruptedProjectile)entityInside;
            if (CorruptionRecipe.canBeCorrupted(state.m_60734_(), level) && (blockEntity = level.m_7702_(pos)) instanceof IMultiBlockEntity) {
                IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
                corruptedProjectile.m_146870_();
                BlockPos centrePos = entity.getCenter();
                BlockState centreState = level.m_8055_(centrePos);
                this.getFullBlockShape(entity.getCenter(), state, (BlockGetter)level).forEach(pos1 -> this.afterCorruption(centrePos, level, (BlockPos)pos1));
            }
        }
    }

    default public void afterCorruption(BlockPos centrePos, Level level, BlockPos pos) {
        if (!CorruptionRecipe.canBeCorrupted(level.m_8055_(pos).m_60734_(), level)) {
            return;
        }
        Block corruptedBlock = CorruptionRecipe.getCorruptedBlock(level.m_8055_(pos).m_60734_(), level).orElse(Blocks.f_50016_);
        level.m_46597_(pos, corruptedBlock.m_152465_(level.m_8055_(pos)));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            entity.setCenter(centrePos);
        }
    }
}

