/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.corrupted;

import net.abraxator.moresnifferflowers.capability.CapabilityList;
import net.abraxator.moresnifferflowers.capability.CorruptionCapability;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModStatePropertiesUnsafe;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.networking.toClient.CorruptionParticlePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraftforge.network.PacketDistributor;

public class CorruptedGrassBlock
extends SpreadingSnowyDirtBlock {
    public CorruptedGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ModStateProperties.CROWDED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        double d0 = Math.abs(entity.m_20184_().f_82480_);
        if (d0 < 0.1 && !entity.m_20161_()) {
            double d1 = 0.8;
            entity.m_20256_(entity.m_20184_().m_82542_(d1, 1.0, d1));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ModStateProperties.CROWDED});
    }

    private static boolean m_56823_(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = levelReader.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50125_) && (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockstate.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LightEngine.m_284282_((BlockGetter)levelReader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)levelReader, blockpos));
        return i < levelReader.m_7469_();
    }

    private static boolean m_56827_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return CorruptedGrassBlock.m_56823_(state, level, pos) && !level.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.m_6810_(state, level, pos, newState, movedByPiston);
        LevelChunk chunk = level.m_46745_(pos);
        chunk.getCapability(CapabilityList.CORRUPTION).ifPresent(cap -> {
            if (cap.count > 0) {
                --cap.count;
            }
        });
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!CorruptedGrassBlock.m_56823_(state, (LevelReader)level, pos)) {
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            level.m_46597_(pos, Blocks.f_50546_.m_49966_());
        } else {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            if (((Boolean)state.m_61143_((Property)ModStateProperties.CROWDED)).booleanValue()) {
                return;
            }
            if (level.m_46803_(pos.m_7494_()) <= 6 && random.m_188500_() < 0.2 * (Double)ModServerConfig.CORRUPTION_SPREAD_SPEED.get()) {
                BlockState blockstate = this.m_49966_();
                boolean spreadSuccess = false;
                for (int i = 0; i < 4 && !spreadSuccess; ++i) {
                    spreadSuccess = CorruptedGrassBlock.spread(level, pos, random, blockstate);
                }
                CorruptedGrassBlock.placeCorruptedLeaves(level, pos, random);
                CorruptedGrassBlock.placeTallGrass(level, pos);
            }
        }
    }

    private static void placeCorruptedLeaves(ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos blockPos1 = pos.m_6630_(random.m_188503_(6));
        BlockState state2 = level.m_8055_(blockPos1);
        if (state2.m_61145_((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED).isPresent() && ((Boolean)state2.m_61143_((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED)).booleanValue()) {
            level.m_7731_(blockPos1, (BlockState)state2.m_61124_((Property)ModStatePropertiesUnsafe.NOT_CORRUPTED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private static boolean spread(ServerLevel level, BlockPos pos, RandomSource random, BlockState blockstate) {
        boolean canSpread;
        BlockPos pos1 = pos.m_7918_(random.m_216332_(-2, 2), random.m_216332_(-2, 2), random.m_216332_(-2, 2));
        BlockState state1 = level.m_8055_(pos1);
        boolean bl = canSpread = state1.m_204336_(BlockTags.f_144274_) && CorruptedGrassBlock.m_56827_(blockstate, (LevelReader)level, pos1) && !state1.m_60713_((Block)ModBlocks.CURED_GRASS_BLOCK.get()) && !state1.m_60713_((Block)ModBlocks.CORRUPTED_GRASS_BLOCK.get());
        if (canSpread) {
            if (level.f_46443_) {
                return false;
            }
            if (CorruptedGrassBlock.checkChunks(level, pos, random, blockstate, pos1)) {
                return false;
            }
            level.m_46597_(pos1, (BlockState)blockstate.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(level.m_8055_(pos1.m_7494_()).m_60713_(Blocks.f_50125_))));
            BlockPos posAbove = pos1.m_7494_();
            if (random.m_188501_() < 0.1f && level.m_8055_(posAbove).m_60795_()) {
                level.m_7731_(posAbove, ((Block)ModBlocks.CORRUPTED_WART.get()).m_49966_(), 3);
            }
            return true;
        }
        return false;
    }

    private static boolean checkChunks(ServerLevel level, BlockPos pos, RandomSource random, BlockState blockstate, BlockPos pos1) {
        LevelChunk chunkNew = level.m_46745_(pos1);
        LevelChunk chunkOriginal = level.m_46745_(pos);
        CorruptionCapability capNew = CorruptionCapability.get(chunkNew);
        CorruptionCapability capOriginal = CorruptionCapability.get(chunkOriginal);
        boolean differentChunk = CorruptionCapability.areDifferentChunks((Level)level, pos1, pos);
        boolean isSourceOriginal = capOriginal.isSource;
        boolean isSourceNew = capNew.isSource;
        boolean isNeighborNew = capNew.isNeighbor;
        int count = capNew.count;
        int resistance = capNew.resistance;
        if (differentChunk) {
            if (isSourceOriginal) {
                chunkNew.getCapability(CapabilityList.CORRUPTION).ifPresent(capability -> {
                    capability.isNeighbor = true;
                });
            } else if (isNeighborNew) {
                return true;
            }
        }
        if (!isNeighborNew && !isSourceNew) {
            CorruptedGrassBlock.setCrowded(level, pos, blockstate, resistance, chunkOriginal);
            return true;
        }
        if (isNeighborNew && !isSourceNew) {
            int maxCorruption = 150;
            int maxResistance = 5;
            double chance = 1.0 - (double)count / (double)Math.max(maxCorruption - resistance * (maxCorruption / maxResistance), 1);
            if (chance <= 0.01) {
                CorruptedGrassBlock.setCrowded(level, pos, blockstate, resistance, chunkOriginal);
                return true;
            }
            if (random.m_188500_() > chance) {
                return true;
            }
        }
        ++capNew.count;
        return false;
    }

    private static void setCrowded(ServerLevel level, BlockPos pos, BlockState blockstate, int resistance, LevelChunk chunkOriginal) {
        level.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)ModStateProperties.CROWDED, (Comparable)Boolean.valueOf(true)), 3);
        boolean isPositive = resistance > 0;
        ModPacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new CorruptionParticlePacket(pos, isPositive, false));
        if (isPositive) {
            CorruptionCapability.sendFlowerParticles(chunkOriginal);
        }
    }

    private static void placeTallGrass(ServerLevel level, BlockPos pos) {
        if (level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50034_)) {
            level.m_7731_(pos.m_7494_(), ((Block)ModBlocks.CORRUPTED_GRASS.get()).m_49966_(), 18);
        }
        if (level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50359_)) {
            level.m_7731_(pos.m_7494_(), (BlockState)((Block)ModBlocks.CORRUPTED_TALL_GRASS.get()).m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER), 18);
            level.m_7731_(pos.m_6630_(2), (BlockState)((Block)ModBlocks.CORRUPTED_TALL_GRASS.get()).m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER), 18);
        }
    }
}

