/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.blockentities.DyespriaPlantBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.ModEntityBlock;
import net.abraxator.moresnifferflowers.components.Dye;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DyespriaPlantBlock
extends BushBlock
implements ModCropBlock,
ModEntityBlock,
Corruptable {
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public DyespriaPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false))).m_61124_(ModStateProperties.COLOR, (Comparable)DyeColor.WHITE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{this.getAgeProperty()}).m_61104_(new Property[]{ModStateProperties.COLOR}).m_61104_(new Property[]{ModStateProperties.SHEARED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)placer;
            ModAdvancementCritters.PLACED_DYESPRIA_PLANT.m_222618_(serverPlayer);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        ItemStack stack = player.m_21120_(hand);
        if (this.shear(player, level, pos, hand)) {
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(Items.f_42499_) && !this.isMaxAge(state)) {
            return InteractionResult.PASS;
        }
        if (this.isMaxAge(state) && (blockEntity = level.m_7702_(pos)) instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            if (stack.m_41720_() instanceof DyeItem) {
                return this.addDye(stack, player, level, entity);
            }
        } else if (this.isMaxAge(state) && (blockEntity = level.m_7702_(pos)) instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            player.m_36356_(Dye.stackFromDye(entity.removeDye()));
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    private InteractionResult addDye(ItemStack dye, Player player, Level level, DyespriaPlantBlockEntity entity) {
        if (!level.f_46443_) {
            ItemStack stack = dye.m_41777_();
            dye.m_41764_(-1);
            player.m_36356_(entity.add(null, entity.dye, stack));
        }
        level.m_5594_(null, entity.m_58899_(), SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, (float)(1.0 + (double)level.f_46441_.m_188501_() * 0.2));
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return this.m_7898_(state, (LevelReader)level, currentPos) ? state : Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.mayPlaceOn(level.m_8055_(pos.m_7495_()));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        if (!newState.m_60713_((Block)ModBlocks.DYESCRAPIA_PLANT.get()) && !state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            if (this.isMaxAge(state)) {
                ItemStack dyespria = ((Item)ModItems.DYESPRIA.get()).m_7968_();
                dyespria.m_41784_().m_128405_("amount", entity.dye.amount());
                dyespria.m_41784_().m_128405_("color", entity.dye.colorId());
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)dyespria);
            }
        }
        super.m_6810_(state, level, pos, newState, pMovedByPiston);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        this.onCorruptByEntity(entity, pos, state, (Block)this, level);
    }

    @Override
    public void onCorrupt(Level level, BlockPos pos, BlockState oldState, Block corruptedBlock) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            if (this.isMaxAge(oldState)) {
                ItemStack dye = new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)entity.dye.color()), entity.dye.amount());
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)dye);
            }
        }
        Corruptable.super.onCorrupt(level, pos, oldState, corruptedBlock);
    }

    @Override
    public boolean mayPlaceOn(BlockState state) {
        return state.m_204336_(BlockTags.f_144274_) && !(state.m_60734_() instanceof FarmBlock);
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_3;
    }

    public boolean m_6724_(BlockState state) {
        return this.isMaxAge(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.makeGrowOnTick(state, (Level)level, pos);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean pIsClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.makeGrowOnBonemeal((Level)level, pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        if (player.m_6144_() && this.isMaxAge(state) && (blockEntity = level.m_7702_(pos)) instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            ItemStack stack = ((Item)ModItems.DYESPRIA.get()).m_7968_();
            Dye.setDyeToDyeHolderStack(stack, Dye.stackFromDye(entity.dye), entity.dye.amount());
            return stack;
        }
        return ((Item)ModItems.DYESPRIA_SEEDS.get()).m_7968_();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DyespriaPlantBlockEntity(pos, state);
    }
}

