/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DripsaltBlock
extends PointedDripstoneBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.f_155997_;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.f_155998_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final int MAX_SEARCH_LENGTH_WHEN_CHECKING_DRIP_TYPE = 11;
    private static final int DELAY_BEFORE_FALLING = 2;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK = 0.02f;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK_IF_UNDER_LIQUID_SOURCE = 0.12f;
    private static final int MAX_SEARCH_LENGTH_BETWEEN_STALACTITE_TIP_AND_CAULDRON = 11;
    private static final float WATER_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.17578125f;
    private static final float LAVA_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.05859375f;
    private static final double MIN_TRIDENT_VELOCITY_TO_BREAK_DRIPSTONE = 0.6;
    private static final float STALACTITE_DAMAGE_PER_FALL_DISTANCE_AND_SIZE = 1.0f;
    private static final int STALACTITE_MAX_DAMAGE = 40;
    private static final int MAX_STALACTITE_HEIGHT_FOR_DAMAGE_CALCULATION = 6;
    private static final float STALAGMITE_FALL_DISTANCE_OFFSET = 2.0f;
    private static final int STALAGMITE_FALL_DAMAGE_MODIFIER = 2;
    private static final float AVERAGE_DAYS_PER_GROWTH = 5.0f;
    private static final float GROWTH_PROBABILITY_PER_RANDOM_TICK = 0.011377778f;
    private static final int MAX_GROWTH_LENGTH = 7;
    private static final int MAX_STALAGMITE_SEARCH_RANGE_WHEN_GROWING = 10;
    private static final float STALACTITE_DRIP_START_PIXEL = 0.6875f;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final float MAX_HORIZONTAL_OFFSET = 0.125f;
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public DripsaltBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TIP_DIRECTION, (Comparable)Direction.UP)).m_61124_(THICKNESS, (Comparable)DripstoneThickness.TIP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)ModItems.SALTY_SPICE.get()) && itemStack.m_41613_() >= 5) {
            for (int i = 0; i < 5; ++i) {
                if (!level.m_8055_(pos.m_6630_(i + 1)).m_60795_() || !level.m_8055_(pos.m_6630_(i)).m_60713_((Block)this)) continue;
                level.m_7731_(pos.m_6630_(i + 1), this.m_49966_(), 3);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(5);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return DripsaltBlock.m_154221_(level, pos, (Direction)state.m_61143_((Property)TIP_DIRECTION));
    }

    public BlockState m_7417_(BlockState state, Direction p_direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (p_direction != Direction.UP && p_direction != Direction.DOWN) {
            return state;
        }
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        if (direction == Direction.DOWN && level.m_183326_().m_183582_(pos, (Object)this)) {
            return state;
        }
        if (p_direction == direction.m_122424_() && !this.m_7898_(state, (LevelReader)level, pos)) {
            if (direction == Direction.DOWN) {
                level.m_186460_(pos, (Block)this, 2);
            } else {
                level.m_186460_(pos, (Block)this, 1);
            }
            return state;
        }
        boolean flag = state.m_61143_(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = DripsaltBlock.m_154092_((LevelReader)level, pos, direction, flag);
        return (BlockState)state.m_61124_(THICKNESS, (Comparable)dripstonethickness);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos = hit.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, blockpos) && projectile instanceof ThrownTrident && projectile.m_20184_().m_82553_() > 0.6) {
            level.m_46961_(blockpos, true);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.m_61143_((Property)TIP_DIRECTION) == Direction.UP && state.m_61143_(THICKNESS) == DripstoneThickness.TIP) {
            entity.m_142535_(fallDistance + 2.0f, 2.0f, level.m_269111_().m_269571_());
        } else {
            super.m_142072_(level, state, pos, entity, fallDistance);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        float f;
        if (DripsaltBlock.m_154238_(state) && !((f = random.m_188501_()) > 0.12f)) {
            DripsaltBlock.m_154181_(level, pos, state).filter(p_221848_ -> f < 0.02f || DripsaltBlock.m_154158_(p_221848_.fluid)).ifPresent(p_221881_ -> DripsaltBlock.m_154071_(level, pos, state, p_221881_.fluid));
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (DripsaltBlock.m_154242_(state) && !this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        } else {
            DripsaltBlock.m_154097_(state, level, pos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        DripsaltBlock.m_221859_(state, level, pos, random.m_188501_());
        if (random.m_188501_() < 0.011377778f && DripsaltBlock.m_154203_(state, (LevelReader)level, pos)) {
            DripsaltBlock.m_221887_(state, level, pos, random);
        }
    }

    @VisibleForTesting
    public static void m_221859_(BlockState state, ServerLevel level, BlockPos pos, float randChance) {
        Optional<FluidInfo> optional;
        if (!(randChance > 0.17578125f && randChance > 0.05859375f || !DripsaltBlock.m_154203_(state, (LevelReader)level, pos) || (optional = DripsaltBlock.m_154181_((Level)level, pos, state)).isEmpty())) {
            BlockPos blockpos;
            float f;
            Fluid fluid = optional.get().fluid;
            if (fluid == Fluids.f_76193_) {
                f = 0.17578125f;
            } else {
                if (fluid != Fluids.f_76195_) {
                    return;
                }
                f = 0.05859375f;
            }
            if (!(randChance >= f) && (blockpos = DripsaltBlock.m_154130_(state, (LevelAccessor)level, pos, 11, false)) != null) {
                if (optional.get().sourceState.m_60713_(Blocks.f_220864_) && fluid == Fluids.f_76193_) {
                    BlockState blockstate1 = Blocks.f_50129_.m_49966_();
                    level.m_46597_(optional.get().pos, blockstate1);
                    Block.m_49897_((BlockState)optional.get().sourceState, (BlockState)blockstate1, (LevelAccessor)level, (BlockPos)optional.get().pos);
                    level.m_220407_(GameEvent.f_157792_, optional.get().pos, GameEvent.Context.m_223722_((BlockState)blockstate1));
                    level.m_46796_(1504, blockpos, 0);
                } else {
                    BlockPos blockpos1 = DripsaltBlock.m_154076_((Level)level, blockpos, fluid);
                    if (blockpos1 != null) {
                        level.m_46796_(1504, blockpos, 0);
                        int i = blockpos.m_123342_() - blockpos1.m_123342_();
                        int j = 50 + i;
                        BlockState blockstate = level.m_8055_(blockpos1);
                        level.m_186460_(blockpos1, blockstate.m_60734_(), j);
                    }
                }
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = context.m_43725_();
        Direction direction1 = DripsaltBlock.m_154190_((LevelReader)levelaccessor, blockpos = context.m_8083_(), direction = context.m_151260_().m_122424_());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !context.m_7078_();
        DripstoneThickness dripstonethickness = DripsaltBlock.m_154092_((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction1)).m_61124_(THICKNESS, (Comparable)dripstonethickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.m_61143_(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (state.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = state.m_60824_(level, pos);
        return voxelshape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public float m_142740_() {
        return 0.125f;
    }

    public void m_142525_(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        if (!fallingBlock.m_20067_()) {
            level.m_46796_(1045, pos, 0);
        }
    }

    public DamageSource m_252932_(Entity entity) {
        return entity.m_269291_().m_269103_(entity);
    }

    private static void m_154097_(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        BlockState blockstate = state;
        while (DripsaltBlock.m_154240_(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (DripsaltBlock.m_154153_(blockstate, true)) {
                int i = Math.max(1 + pos.m_123342_() - blockpos$mutableblockpos.m_123342_(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.m_149656_(f, 40);
                break;
            }
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
        }
    }

    @VisibleForTesting
    public static void m_221887_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockstate2;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = level.m_8055_(pos.m_6630_(1));
        if (DripsaltBlock.m_154140_(blockstate, blockstate1 = level.m_8055_(pos.m_6630_(2))) && (blockpos = DripsaltBlock.m_154130_(state, (LevelAccessor)level, pos, 7, false)) != null && DripsaltBlock.m_154238_(blockstate2 = level.m_8055_(blockpos)) && DripsaltBlock.m_154194_(blockstate2, level, blockpos)) {
            if (random.m_188499_()) {
                DripsaltBlock.m_154035_(level, blockpos, Direction.DOWN);
            } else {
                DripsaltBlock.m_154032_(level, blockpos);
            }
        }
    }

    private static void m_154032_(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        for (int i = 0; i < 10; ++i) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            BlockState blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (!blockstate.m_60819_().m_76178_()) {
                return;
            }
            if (DripsaltBlock.m_154143_(blockstate, Direction.UP) && DripsaltBlock.m_154194_(blockstate, level, (BlockPos)blockpos$mutableblockpos)) {
                DripsaltBlock.m_154035_(level, (BlockPos)blockpos$mutableblockpos, Direction.UP);
                return;
            }
            if (DripsaltBlock.m_154221_((LevelReader)level, (BlockPos)blockpos$mutableblockpos, Direction.UP) && !level.m_46801_(blockpos$mutableblockpos.m_7495_())) {
                DripsaltBlock.m_154035_(level, blockpos$mutableblockpos.m_7495_(), Direction.UP);
                return;
            }
            if (DripsaltBlock.m_202017_((BlockGetter)level, (BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return;
        }
    }

    private static void m_154035_(ServerLevel server, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.m_121945_(direction);
        BlockState blockstate = server.m_8055_(blockpos);
        if (DripsaltBlock.m_154143_(blockstate, direction.m_122424_())) {
            DripsaltBlock.m_154230_(blockstate, (LevelAccessor)server, blockpos);
        } else if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49990_)) {
            DripsaltBlock.m_154087_((LevelAccessor)server, blockpos, direction, DripstoneThickness.TIP);
        }
    }

    private static void m_154087_(LevelAccessor level, BlockPos pos, Direction direction, DripstoneThickness thickness) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.DRIPSALT.get()).m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction)).m_61124_(THICKNESS, (Comparable)thickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        level.m_7731_(pos, blockstate, 3);
    }

    private static void m_154230_(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockPos blockpos;
        BlockPos blockpos1;
        if (state.m_61143_((Property)TIP_DIRECTION) == Direction.UP) {
            blockpos1 = pos;
            blockpos = pos.m_7494_();
        } else {
            blockpos = pos;
            blockpos1 = pos.m_7495_();
        }
        DripsaltBlock.m_154087_(level, blockpos, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        DripsaltBlock.m_154087_(level, blockpos1, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    public static void m_154062_(Level level, BlockPos pos, BlockState state) {
        DripsaltBlock.m_154181_(level, pos, state).ifPresent(p_221856_ -> DripsaltBlock.m_154071_(level, pos, state, p_221856_.fluid));
    }

    private static void m_154071_(Level level, BlockPos pos, BlockState state, Fluid p_fluid) {
        Vec3 vec3 = state.m_60824_((BlockGetter)level, pos);
        double d0 = 0.0625;
        double d1 = (double)pos.m_123341_() + 0.5 + vec3.f_82479_;
        double d2 = (double)((float)(pos.m_123342_() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.m_123343_() + 0.5 + vec3.f_82481_;
        Fluid fluid = DripsaltBlock.m_154052_(level, p_fluid);
        SimpleParticleType particleoptions = fluid.m_205067_(FluidTags.f_13132_) ? ParticleTypes.f_175822_ : ParticleTypes.f_175824_;
        level.m_7106_((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos m_154130_(BlockState state, LevelAccessor level, BlockPos pos, int maxIterations, boolean isTipMerge) {
        if (DripsaltBlock.m_154153_(state, isTipMerge)) {
            return pos;
        }
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202023_, p_202024_) -> p_202024_.m_60713_((Block)ModBlocks.DRIPSALT.get()) && p_202024_.m_61143_((Property)TIP_DIRECTION) == direction;
        return DripsaltBlock.m_202006_(level, pos, direction.m_122421_(), bipredicate, p_154168_ -> DripsaltBlock.m_154153_(p_154168_, isTipMerge), maxIterations).orElse(null);
    }

    @Nullable
    private static Direction m_154190_(LevelReader level, BlockPos pos, Direction dir) {
        Direction direction;
        if (DripsaltBlock.m_154221_(level, pos, dir)) {
            direction = dir;
        } else {
            if (!DripsaltBlock.m_154221_(level, pos, dir.m_122424_())) {
                return null;
            }
            direction = dir.m_122424_();
        }
        return direction;
    }

    private static DripstoneThickness m_154092_(LevelReader level, BlockPos pos, Direction dir, boolean isTipMerge) {
        Direction direction = dir.m_122424_();
        BlockState blockstate = level.m_8055_(pos.m_121945_(dir));
        if (DripsaltBlock.m_154207_(blockstate, direction)) {
            return !isTipMerge && blockstate.m_61143_(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!DripsaltBlock.m_154207_(blockstate, dir)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.m_61143_(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = level.m_8055_(pos.m_121945_(direction));
            return !DripsaltBlock.m_154207_(blockstate1, dir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean m_154238_(BlockState state) {
        return DripsaltBlock.m_154240_(state) && state.m_61143_(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    private static boolean m_154194_(BlockState state, ServerLevel level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BlockPos blockpos = pos.m_121945_(direction);
        BlockState blockstate = level.m_8055_(blockpos);
        if (!blockstate.m_60819_().m_76178_()) {
            return false;
        }
        return blockstate.m_60795_() ? true : DripsaltBlock.m_154143_(blockstate, direction.m_122424_());
    }

    private static Optional<BlockPos> m_154066_(Level level, BlockPos pos, BlockState state, int maxIterations) {
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202015_, p_202016_) -> p_202016_.m_60713_((Block)ModBlocks.DRIPSALT.get()) && p_202016_.m_61143_((Property)TIP_DIRECTION) == direction;
        return DripsaltBlock.m_202006_((LevelAccessor)level, pos, direction.m_122424_().m_122421_(), bipredicate, p_154245_ -> !p_154245_.m_60713_((Block)ModBlocks.DRIPSALT.get()), maxIterations);
    }

    private static boolean m_154221_(LevelReader level, BlockPos pos, Direction dir) {
        BlockPos blockpos = pos.m_121945_(dir.m_122424_());
        BlockState blockstate = level.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)level, blockpos, dir) || DripsaltBlock.m_154207_(blockstate, dir);
    }

    private static boolean m_154153_(BlockState state, boolean isTipMerge) {
        if (!state.m_60713_((Block)ModBlocks.DRIPSALT.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.m_61143_(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || isTipMerge && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean m_154143_(BlockState state, Direction dir) {
        return DripsaltBlock.m_154153_(state, false) && state.m_61143_((Property)TIP_DIRECTION) == dir;
    }

    private static boolean m_154240_(BlockState state) {
        return DripsaltBlock.m_154207_(state, Direction.DOWN);
    }

    private static boolean m_154242_(BlockState state) {
        return DripsaltBlock.m_154207_(state, Direction.UP);
    }

    private static boolean m_154203_(BlockState state, LevelReader level, BlockPos pos) {
        return DripsaltBlock.m_154240_(state) && !level.m_8055_(pos.m_7494_()).m_60713_((Block)ModBlocks.DRIPSALT.get());
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    private static boolean m_154207_(BlockState state, Direction dir) {
        return state.m_60713_((Block)ModBlocks.DRIPSALT.get()) && state.m_61143_((Property)TIP_DIRECTION) == dir;
    }

    @Nullable
    private static BlockPos m_154076_(Level level, BlockPos pos, Fluid fluid) {
        Predicate<BlockState> predicate = p_154162_ -> p_154162_.m_60734_() instanceof AbstractCauldronBlock;
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202034_, p_202035_) -> DripsaltBlock.m_202017_((BlockGetter)level, p_202034_, p_202035_);
        return DripsaltBlock.m_202006_((LevelAccessor)level, pos, Direction.DOWN.m_122421_(), bipredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPos m_154055_(Level level, BlockPos pos) {
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202030_, p_202031_) -> DripsaltBlock.m_202017_((BlockGetter)level, p_202030_, p_202031_);
        return DripsaltBlock.m_202006_((LevelAccessor)level, pos, Direction.UP.m_122421_(), bipredicate, PointedDripstoneBlock::m_154238_, 11).orElse(null);
    }

    public static Fluid m_221849_(ServerLevel level, BlockPos pos) {
        return DripsaltBlock.m_154181_((Level)level, pos, level.m_8055_(pos)).map(p_221858_ -> p_221858_.fluid).filter(DripsaltBlock::m_154158_).orElse(Fluids.f_76191_);
    }

    private static Optional<FluidInfo> m_154181_(Level level, BlockPos pos, BlockState state) {
        return !DripsaltBlock.m_154240_(state) ? Optional.empty() : DripsaltBlock.m_154066_(level, pos, state, 11).map(p_221876_ -> {
            BlockPos blockpos = p_221876_.m_7494_();
            BlockState blockstate = level.m_8055_(blockpos);
            Object fluid = blockstate.m_60713_(Blocks.f_220864_) && !level.m_6042_().f_63857_() ? Fluids.f_76193_ : level.m_6425_(blockpos).m_76152_();
            return new FluidInfo(blockpos, (Fluid)fluid, blockstate);
        });
    }

    private static boolean m_154158_(Fluid fluid) {
        return fluid == Fluids.f_76195_ || fluid == Fluids.f_76193_;
    }

    private static boolean m_154140_(BlockState dripstoneState, BlockState state) {
        return dripstoneState.m_60713_(Blocks.f_152537_) && state.m_60713_(Blocks.f_49990_) && state.m_60819_().m_76170_();
    }

    private static Fluid m_154052_(Level level, Fluid fluid) {
        if (fluid.m_6212_(Fluids.f_76191_)) {
            return level.m_6042_().f_63857_() ? Fluids.f_76195_ : Fluids.f_76193_;
        }
        return fluid;
    }

    private static Optional<BlockPos> m_202006_(LevelAccessor level, BlockPos pos, Direction.AxisDirection axis, BiPredicate<BlockPos, BlockState> positionalStatePredicate, Predicate<BlockState> statePredicate, int maxIterations) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)axis, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        for (int i = 1; i < maxIterations; ++i) {
            blockpos$mutableblockpos.m_122173_(direction);
            BlockState blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (statePredicate.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.m_7949_());
            }
            if (!level.m_151562_(blockpos$mutableblockpos.m_123342_()) && positionalStatePredicate.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean m_202017_(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_60804_(level, pos)) {
            return false;
        }
        if (!state.m_60819_().m_76178_()) {
            return false;
        }
        VoxelShape voxelshape = state.m_60812_(level, pos);
        return !Shapes.m_83157_((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_);
    }

    record FluidInfo(BlockPos pos, Fluid fluid, BlockState sourceState) {
    }
}

