/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;

public class BonmeeliaBlock
extends BushBlock
implements ModCropBlock,
Corruptable {
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)6);
    public static final BooleanProperty HAS_BOTTLE = BooleanProperty.m_61465_((String)"bottle");
    public static final BooleanProperty SHOW_HINT = BooleanProperty.m_61465_((String)"hint");
    public static final BooleanProperty HAS_JAR = BooleanProperty.m_61465_((String)"jar");
    public static final int MAX_AGE = AGE.m_61702_().map(Property.Value::f_61713_).max(Integer::compare).orElse(0);
    private final boolean wilted;

    public BonmeeliaBlock(BlockBehaviour.Properties properties, boolean wilted) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HAS_BOTTLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SHOW_HINT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)HAS_JAR, (Comparable)Boolean.valueOf(false)));
        this.wilted = wilted;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, HAS_BOTTLE, SHOW_HINT, HAS_JAR});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.mayPlaceOn(level.m_8055_(pos.m_7495_()));
    }

    @Override
    public boolean mayPlaceOn(BlockState state) {
        return ModCropBlock.super.mayPlaceOn(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.m_21205_();
        if (itemStack.m_150930_(Items.f_42590_) && this.canInsertBottle(state)) {
            return this.addBottle(level, pos, state, itemStack, player);
        }
        if (((Boolean)state.m_61143_((Property)HAS_BOTTLE)).booleanValue() && (Integer)state.m_61143_((Property)AGE) >= MAX_AGE) {
            return this.takeJarOfBonmeel(level, pos, state, player);
        }
        if (!((Boolean)state.m_61143_((Property)HAS_BOTTLE)).booleanValue() && this.getAge(state) >= 3) {
            return this.hint(level, pos, state);
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SHOW_HINT, (Comparable)Boolean.valueOf(false)), 3);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        this.onCorruptByEntity(entity, pos, state, (Block)this, level);
    }

    private InteractionResult addBottle(Level level, BlockPos blockPos, BlockState blockState, ItemStack stack, Player player) {
        level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)HAS_BOTTLE, (Comparable)Boolean.valueOf(true)), 3);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private InteractionResult takeJarOfBonmeel(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(3))).m_61124_((Property)HAS_BOTTLE, (Comparable)Boolean.valueOf(false)), 3);
        BonmeeliaBlock.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)(this.wilted ? ((Item)ModItems.JAR_OF_ACID.get()).m_7968_() : ((Item)ModItems.JAR_OF_BONMEEL.get()).m_7968_()));
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private InteractionResult hint(Level level, BlockPos blockPos, BlockState blockState) {
        level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)SHOW_HINT, (Comparable)Boolean.valueOf(true)), 3);
        level.m_183326_().m_183393_(new ScheduledTick((Object)this, blockPos, level.m_46467_() + 40L, level.m_183596_()));
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public boolean m_6724_(BlockState state) {
        return this.getAge(state) < 3 || this.getAge(state) >= 3 && (Boolean)state.m_61143_((Property)HAS_BOTTLE) != false;
    }

    private boolean canInsertBottle(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)AGE) == 3 && (Boolean)blockState.m_61143_((Property)HAS_BOTTLE) == false;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.isMaxAge(state)) {
            level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(this.getAge(state) + 1))).m_61124_((Property)HAS_JAR, (Comparable)Boolean.valueOf(this.getAge(state) + 1 == MAX_AGE && (Boolean)state.m_61143_((Property)HAS_BOTTLE) != false)));
            DustParticleOptions particle = new DustParticleOptions(this.wilted ? Vec3.m_82501_((int)11468636).m_252839_() : Vec3.m_82501_((int)11162034).m_252839_(), 1.0f);
            if (this.getAge(state) >= 3) {
                for (int i = 0; i <= random.m_216332_(5, 10); ++i) {
                    level.m_8767_((ParticleOptions)particle, (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + random.m_188500_(), (double)pos.m_123343_() + random.m_188500_(), 1, 0.0, 0.0, 0.0, 0.3);
                }
            }
        }
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean pIsClient) {
        return this.getAge(state) < 3;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.makeGrowOnBonemeal((Level)level, pos, state);
    }
}

