/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import java.util.ArrayList;
import java.util.List;
import net.abraxator.moresnifferflowers.blockentities.BondripiaBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Bonmeelable;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.blocks.GiantCropBlock;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.multiblock.ICorruptableMultiblock;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import net.nikdo53.tinymultiblocklib.blockentities.IMultiBlockEntity;
import net.nikdo53.tinymultiblocklib.components.SyncedStatePropertiesBuilder;
import org.jetbrains.annotations.Nullable;

public class BondripiaBlock
extends AbstractMultiBlock
implements EntityBlock,
ModCropBlock,
Corruptable,
IPreviewableMultiblock,
ICorruptableMultiblock {
    private static final VoxelShape SHAPE = BondripiaBlock.makeShape();

    public BondripiaBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ModStateProperties.CENTER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{this.getAgeProperty(), ModStateProperties.SHEARED});
    }

    public BlockState getDefaultStateForPreviews(Direction direction) {
        return (BlockState)super.getDefaultStateForPreviews(direction).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge()));
    }

    public void createSyncedBlockStates(SyncedStatePropertiesBuilder builder) {
        super.createSyncedBlockStates(builder);
        builder.add((Property)ModStateProperties.SHEARED);
        builder.add((Property)this.getAgeProperty());
    }

    public List<BlockPos> makeFullBlockShape(@Nullable Direction direction, BlockPos center, BlockState blockState) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(center.m_7949_());
        positions.addAll(Direction.Plane.HORIZONTAL.m_122557_().map(direction1 -> center.m_121945_(direction1).m_7949_()).toList());
        return positions;
    }

    public RenderShape getMultiblockRenderShape(BlockState state) {
        if (!IMultiBlock.isCenter((BlockState)state)) {
            return RenderShape.INVISIBLE;
        }
        if (this.getAge(state) == this.getMaxAge()) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return RenderShape.MODEL;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        this.spawnBonmeeliaParticles(state, level, pos, random);
    }

    private void spawnBonmeeliaParticles(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        boolean isAcidripia = state.m_60713_((Block)ModBlocks.ACIDRIPIA.get());
        if (((Boolean)state.m_61143_((Property)ModStateProperties.CENTER)).booleanValue() && this.isMaxAge(state) && (blockEntity = level.m_7702_(pos)) instanceof IMultiBlockEntity) {
            IMultiBlockEntity entity = (IMultiBlockEntity)blockEntity;
            if ((double)random.m_188501_() < 0.4) {
                BlockPos.m_121985_((BlockPos)entity.getCenter(), (int)1, (int)0, (int)1).forEach(blockPos -> {
                    SimpleParticleType fallParticles;
                    Vec3 vec3 = blockPos.m_252807_();
                    BlockPos difference = blockPos.m_121996_((Vec3i)entity.getCenter());
                    boolean isCorner = Math.abs(difference.m_123341_()) + Math.abs(difference.m_123343_()) == 2;
                    boolean isMid = blockPos.equals((Object)entity.getCenter());
                    BlockPos pos2 = blockPos.m_6625_(random.m_188503_(8));
                    SimpleParticleType dripParticles = isAcidripia ? (SimpleParticleType)ModParticles.ACIDRIPIA_DRIP.get() : (SimpleParticleType)ModParticles.BONDRIPIA_DRIP.get();
                    SimpleParticleType simpleParticleType = fallParticles = isAcidripia ? (SimpleParticleType)ModParticles.ACIDRIPIA_FALL.get() : (SimpleParticleType)ModParticles.BONDRIPIA_FALL.get();
                    if ((double)random.m_188501_() < 0.5) {
                        if (isMid) {
                            level.m_7106_((ParticleOptions)dripParticles, vec3.f_82479_ + (double)random.m_216332_(-1, 1) * 0.15, vec3.f_82480_ - 0.25, vec3.f_82481_ + (double)random.m_216332_(-1, 1) * 0.15, 0.0, 1.0, 0.0);
                        } else if (isCorner) {
                            level.m_7106_((ParticleOptions)fallParticles, vec3.f_82479_ - (double)difference.m_123341_() * 0.05, vec3.f_82480_, vec3.f_82481_ - (double)difference.m_123343_() * 0.05, 0.0, 1.0, 0.0);
                        } else {
                            level.m_7106_((ParticleOptions)dripParticles, vec3.f_82479_ - (double)difference.m_123341_() * 0.1, vec3.f_82480_, vec3.f_82481_ - (double)difference.m_123343_() * 0.1, 0.0, 1.0, 0.0);
                        }
                    }
                    if (level.m_8055_(pos2).m_280296_() && level.m_8055_(pos2.m_7495_()).m_60795_()) {
                        ParticleUtils.m_272037_((Level)level, (BlockPos)pos2, (RandomSource)random, (ParticleOptions)dripParticles);
                    }
                });
            }
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Object object;
        if (((Boolean)state.m_61143_((Property)ModStateProperties.SHEARED)).booleanValue()) {
            return;
        }
        if (!this.isMaxAge(state) && IMultiBlock.isCenter((BlockState)state)) {
            this.grow((Level)level, pos, state);
        } else if (random.m_188500_() <= 0.33 && (object = level.m_7702_(pos)) instanceof BondripiaBlockEntity) {
            BondripiaBlockEntity entity = (BondripiaBlockEntity)((Object)object);
            object = BlockPos.m_121940_((BlockPos)entity.getCenter().m_7495_().m_122012_().m_122029_(), (BlockPos)entity.getCenter().m_7495_().m_122019_().m_122024_()).iterator();
            while (object.hasNext()) {
                BlockPos blockPos;
                BlockPos currentPos = blockPos = (BlockPos)object.next();
                int y = level.m_213780_().m_216332_(1, 11);
                if (this.isBondripable((Level)level, currentPos = currentPos.m_6625_(y))) {
                    Bonmeelable bonmeelable;
                    BonemealableBlock bonemealable;
                    BlockState blockState = level.m_8055_(currentPos);
                    Block block = blockState.m_60734_();
                    if (block instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)block).m_7370_((LevelReader)level, currentPos, blockState, false)) {
                        bonemealable.m_214148_(level, random, currentPos, blockState);
                        break;
                    }
                    if (!blockState.m_204336_(ModTags.ModBlockTags.BONMEELABLE) || !(bonmeelable = (Bonmeelable)GiantCropBlock.getCropMap().get(blockState.m_60734_()).getA()).canBonmeel(currentPos, blockState, (Level)level, null)) continue;
                    bonmeelable.performBonmeel(currentPos, blockState, (Level)level, null);
                    break;
                }
                Block block = level.m_8055_(currentPos).m_60734_();
                if (!(block instanceof AbstractCauldronBlock)) continue;
                AbstractCauldronBlock block2 = (AbstractCauldronBlock)block;
                this.fillCauldron((Level)level, currentPos, level.m_8055_(currentPos));
            }
        }
    }

    public void fillCauldron(Level level, BlockPos blockPos, BlockState blockState) {
        BlockState blockstate = blockState.m_60713_((Block)ModBlocks.ACIDRIPIA.get()) ? ((Block)ModBlocks.ACID_FILLED_CAULDRON.get()).m_49966_() : ((Block)ModBlocks.BONMEEL_FILLED_CAULDRON.get()).m_49966_();
        int fluidLevel = level.m_8055_(blockPos).m_61145_((Property)LayeredCauldronBlock.f_153514_).orElse(0);
        if (fluidLevel < 3) {
            level.m_46597_(blockPos, (BlockState)blockstate.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(fluidLevel + 1)));
            level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223722_((BlockState)blockstate));
            level.m_46796_(1047, blockPos, 0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.shear(player, level, pos, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entityinside) {
        this.corruptionHelper(state, level, pos, entityinside);
    }

    public void grow(Level level, BlockPos blockPos, BlockState state) {
        if (IMultiBlock.isCenter((BlockState)state)) {
            this.makeGrowOnBonemeal(level, blockPos, state);
        }
    }

    private boolean isBondripable(Level level, BlockPos blockPos) {
        return level.m_8055_(blockPos).m_60734_() instanceof BonemealableBlock || level.m_8055_(blockPos).m_204336_(ModTags.ModBlockTags.BONMEELABLE);
    }

    public boolean extraSurviveRequirements(LevelReader level, BlockPos pos, BlockState state) {
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_7494_(), (Direction)Direction.DOWN) && !level.m_46801_(pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BondripiaBlockEntity(pos, state);
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_2;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean pIsClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.makeGrowOnBonemeal((Level)level, pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.voxelShapeHelper(state, getter, pos, SHAPE);
    }

    @Override
    public Block getCuredBlock() {
        return (Block)ModBlocks.BONDRIPIA.get();
    }

    @Override
    public Block getCorruptedBlock() {
        return (Block)ModBlocks.ACIDRIPIA.get();
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.6875, (double)0.875, (double)0.0, (double)1.6875, (double)1.0625, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.875, (double)-0.6875, (double)1.0, (double)1.0625, (double)1.6875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }
}

