/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.abraxator.moresnifferflowers.blockentities.ModBlockEntity;
import net.abraxator.moresnifferflowers.blocks.Corruptable;
import net.abraxator.moresnifferflowers.entities.CorruptedProjectile;
import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.init.config.ModServerConfig;
import net.abraxator.moresnifferflowers.networking.ModPacketHandler;
import net.abraxator.moresnifferflowers.networking.toClient.CorruptedSludgePacket;
import net.abraxator.moresnifferflowers.recipes.CorruptionRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class CorruptedSludgeBlockEntity
extends ModBlockEntity
implements GameEventListener.Holder<CorruptedSludgeListener> {
    public CorruptedSludgeListener corruptedSludgeListener;
    public int usesLeft = -1;
    public int stateChange;
    public GameEventListener listener;

    public CorruptedSludgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CORRUPTED_SLUDGE.get(), pos, state);
        this.corruptedSludgeListener = new CorruptedSludgeListener((PositionSource)new BlockPositionSource(pos));
        this.listener = new CorruptedSludgeListener((PositionSource)new BlockPositionSource(pos));
    }

    public void updateUses() {
        --this.usesLeft;
        if (this.stateChange == 0) {
            this.stateChange = this.usesLeft / 4;
        }
        if (this.usesLeft % this.stateChange == 0 && (Integer)this.m_58900_().m_61143_((Property)ModStateProperties.USES_4) - 1 != -1) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ModStateProperties.USES_4, (Comparable)Integer.valueOf((Integer)this.m_58900_().m_61143_((Property)ModStateProperties.USES_4) - 1)));
        }
        if (this.usesLeft <= 0) {
            if (((Boolean)ModServerConfig.CORRUPTED_SLUDGE_GRIEFING.get()).booleanValue()) {
                CorruptedSludgeListener.shootProjectiles(this.m_58899_().m_252807_(), this.f_58857_.f_46441_.m_216332_(8, 16), this.f_58857_);
            }
            super.m_7651_();
            this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
        }
    }

    public CorruptedSludgeListener getListener() {
        return this.corruptedSludgeListener;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("uses", this.usesLeft);
        tag.m_128405_("stateChange", this.stateChange);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.usesLeft = tag.m_128451_("uses");
        this.stateChange = tag.m_128451_("stateChange");
    }

    public static class CorruptedSludgeListener
    implements GameEventListener {
        private final PositionSource positionSource;

        public CorruptedSludgeListener(PositionSource positionSource) {
            this.positionSource = positionSource;
        }

        public PositionSource m_142460_() {
            return this.positionSource;
        }

        public int m_142078_() {
            return GameEvent.f_157794_.m_157827_();
        }

        public boolean m_214068_(ServerLevel level, GameEvent pGameEvent, GameEvent.Context context, Vec3 pos) {
            boolean validEvent;
            if (context.f_223712_() == null || this.positionSource.m_142502_((Level)level).isEmpty()) {
                return false;
            }
            BlockEntity blockEntity = level.m_7702_(BlockPos.m_274446_((Position)((Position)this.positionSource.m_142502_((Level)level).get())));
            if (!(blockEntity instanceof CorruptedSludgeBlockEntity)) {
                return false;
            }
            CorruptedSludgeBlockEntity entity = (CorruptedSludgeBlockEntity)blockEntity;
            if (entity.usesLeft == -1) {
                entity.usesLeft = level.f_46441_.m_216332_(16, 32) - 1;
                entity.stateChange = entity.usesLeft / 4;
            }
            boolean bl = validEvent = pGameEvent != GameEvent.f_157797_ || pGameEvent != GameEvent.f_157794_;
            if (entity.usesLeft <= 0 || ((Boolean)entity.m_58900_().m_61143_((Property)ModStateProperties.CURED)).booleanValue() || !validEvent) {
                return false;
            }
            if (pGameEvent == GameEvent.f_157797_ && CorruptionRecipe.canBeCorrupted(context.f_223712_().m_60734_(), (Level)level)) {
                Vec3 startPos = (Vec3)this.positionSource.m_142502_((Level)level).get();
                Vec3 dirNormal = new Vec3(pos.f_82479_ - startPos.f_82479_, pos.f_82480_ - startPos.f_82480_, pos.f_82481_ - startPos.f_82481_).m_82541_();
                Optional<Block> corrupted = CorruptionRecipe.getCorruptedBlock(context.f_223712_().m_60734_(), (Level)level);
                BlockPos blockPos = BlockPos.m_274446_((Position)pos);
                corrupted.ifPresent(block -> {
                    ModPacketHandler.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, 64.0, level.m_46472_())), (Object)new CorruptedSludgePacket(startPos.m_252839_(), pos.m_252839_(), dirNormal.m_252839_()));
                    Block patt6115$temp = level.m_8055_(BlockPos.m_274446_((Position)pos)).m_60734_();
                    if (patt6115$temp instanceof Corruptable) {
                        Corruptable corruptable = (Corruptable)patt6115$temp;
                        corruptable.onCorrupt((Level)level, blockPos, level.m_8055_(BlockPos.m_274446_((Position)pos)), (Block)block);
                    } else {
                        level.m_46597_(BlockPos.m_274446_((Position)pos), block.m_152465_(context.f_223712_()));
                    }
                    level.m_8767_((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)4469320).m_252839_(), 1.0f), (double)blockPos.m_123341_() + level.f_46441_.m_188500_(), (double)blockPos.m_123342_() + level.f_46441_.m_188500_(), (double)blockPos.m_123343_() + level.f_46441_.m_188500_(), 10, 0.0, 0.0, 0.0, 0.0);
                    entity.updateUses();
                });
                return corrupted.isEmpty();
            }
            if (((Boolean)ModServerConfig.CORRUPTED_SLUDGE_GRIEFING.get()).booleanValue() && pGameEvent == GameEvent.f_157794_ && context.f_223712_().m_204336_(ModTags.ModBlockTags.CORRUPTED_SLUDGE) && !pos.equals(this.positionSource.m_142502_((Level)level).get())) {
                int projectileNumber = (context.f_223712_().m_60713_((Block)ModBlocks.CORRUPTED_LEAVES.get()) || context.f_223712_().m_60713_((Block)ModBlocks.CORRUPTED_LEAVES_BUSH.get()) ? level.f_46441_.m_188503_(1) : level.f_46441_.m_188503_(5)) + 2;
                CorruptedSludgeListener.shootProjectiles((Vec3)this.positionSource.m_142502_((Level)level).get(), projectileNumber, (Level)level);
                entity.updateUses();
                return false;
            }
            return false;
        }

        public static void shootProjectiles(Vec3 center, int projectileNumber, Level level) {
            double radius = 2.5;
            HashSet<Vec3> placed = new HashSet<Vec3>();
            for (int i = 0; i < projectileNumber; ++i) {
                CorruptedSludgeListener.generatePoint(placed, center, radius, level);
            }
        }

        private static void generatePoint(Set<Vec3> placed, Vec3 center, double radius, Level level) {
            RandomSource random = level.f_46441_;
            double theta = 6.2831854820251465 * random.m_188500_();
            double phi = Math.acos(2.0 * random.m_188500_() - 1.0);
            double xg = center.f_82479_ + radius * (double)Mth.m_14031_((float)((float)phi)) * (double)Mth.m_14089_((float)((float)theta));
            double yg = center.f_82480_ + radius * (double)Mth.m_14031_((float)((float)phi)) * (double)Mth.m_14031_((float)((float)theta));
            double zg = center.f_82481_ + radius * (double)Mth.m_14089_((float)((float)phi));
            Vec3 vec3 = new Vec3(xg, yg, zg);
            if (placed.stream().noneMatch(vec31 -> AABB.m_165882_((Vec3)vec3, (double)1.0, (double)1.0, (double)1.0).m_82390_(vec31)) && level.m_8055_(BlockPos.m_274446_((Position)vec3)).m_247087_()) {
                Vec3 pos = center;
                double x = random.m_188500_() * 0.5;
                double y = random.m_188500_() * 0.5;
                double z = random.m_188500_() * 0.5;
                CorruptedProjectile projectile = new CorruptedProjectile(level);
                projectile.m_146884_(vec3);
                Vec3 dir = new Vec3(projectile.m_20185_() - pos.f_82479_, projectile.m_20186_() - pos.f_82480_, projectile.m_20189_() - pos.f_82481_).m_82541_().m_82542_(x, y, z);
                projectile.m_20256_(dir);
                level.m_7967_((Entity)projectile);
                placed.add(vec3);
            }
        }
    }
}

