/*
 * Decompiled with CFR 0.152.
 */
package net.poe.acu;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.poe.acu.Config;

@Mod.EventBusSubscriber(modid="acu")
public class ArrowCleanupHandler {
    private static final Map<UUID, Long> arrowsToCleanup = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onProjectileHit(ProjectileImpactEvent event) {
        if (event.getProjectile().m_9236_().m_5776_() || !Config.enableCleanup) {
            return;
        }
        Projectile projectile = event.getProjectile();
        if (projectile instanceof AbstractArrow) {
            Level level;
            AbstractArrow arrow = (AbstractArrow)projectile;
            boolean shouldCleanup = false;
            shouldCleanup = Config.onlyInfinityArrows ? ArrowCleanupHandler.wasFromInfinityItem(arrow) : true;
            if (shouldCleanup && (level = arrow.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                long cleanupTick = (long)serverLevel.m_7654_().m_129921_() + (long)Config.cleanupTime * 20L;
                arrowsToCleanup.put(arrow.m_20148_(), cleanupTick);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !Config.enableCleanup) {
            return;
        }
        long currentTick = event.getServer().m_129921_();
        arrowsToCleanup.entrySet().removeIf(entry -> {
            if (currentTick >= (Long)entry.getValue()) {
                for (ServerLevel level : event.getServer().m_129785_()) {
                    for (Entity entity : level.m_8583_()) {
                        AbstractArrow arrow;
                        if (!(entity instanceof AbstractArrow) || !(arrow = (AbstractArrow)entity).m_20148_().equals(entry.getKey())) continue;
                        arrow.m_146870_();
                        return true;
                    }
                }
                return true;
            }
            return false;
        });
    }

    private static boolean wasFromInfinityItem(AbstractArrow arrow) {
        Entity entity = arrow.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            ItemStack mainHand = owner.m_21205_();
            ItemStack offHand = owner.m_21206_();
            boolean mainHandHasInfinity = !mainHand.m_41619_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)mainHand) > 0;
            boolean offHandHasInfinity = !offHand.m_41619_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)offHand) > 0;
            return mainHandHasInfinity || offHandHasInfinity;
        }
        return false;
    }
}

